/************************************************************************************************/
/* Stata User File for H28 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H28.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H28.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H28.DO                                               */
/* The program below will output the Stata dataset H28.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL98 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID98 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  byte   FCSZ1231 30-31
  byte   FCRP1231 32-33
  str    RULETR31 34-35
  str    RULETR42 36-37
  str    RULETR53 38-39
  str    RULETR98 40-41
  byte   RUSIZE31 42-43
  byte   RUSIZE42 44-45
  byte   RUSIZE53 46-47
  byte   RUSIZE98 48-49
  byte   RUCLAS31 50-51
  byte   RUCLAS42 52-53
  byte   RUCLAS53 54-55
  byte   RUCLAS98 56-56
  byte   FAMSZE31 57-58
  byte   FAMSZE42 59-60
  byte   FAMSZE53 61-62
  byte   FAMSZE98 63-64
  byte   FMRS1231 65-66
  byte   FAMS1231 67-68
  byte   FAMSZEYR 69-70
  byte   FAMRFPYR 71-72
  byte   FYFAMTYP 73-73
  byte   INRU1231 74-74
  byte   REGION31 75-76
  byte   REGION42 77-78
  byte   REGION53 79-80
  byte   REGION98 81-82
  byte   MSA53 83-84
  byte   MSA98 85-86
  int    REFPRS31 87-89
  int    REFPRS42 90-92
  int    REFPRS53 93-95
  int    REFPRS98 96-98
  byte   RESP31 99-99
  byte   RESP42 100-100
  byte   RESP53 101-101
  byte   RESP98 102-102
  byte   PROXY31 103-104
  byte   PROXY42 105-106
  byte   PROXY53 107-108
  byte   PROXY98 109-109
  byte   BEGRFD31 110-111
  byte   BEGRFM31 112-113
  int    BEGRFY31 114-117
  byte   ENDRFD31 118-119
  byte   ENDRFM31 120-121
  int    ENDRFY31 122-125
  byte   BEGRFD42 126-127
  byte   BEGRFM42 128-129
  int    BEGRFY42 130-133
  byte   ENDRFD42 134-135
  byte   ENDRFM42 136-137
  int    ENDRFY42 138-141
  byte   BEGRFD53 142-143
  byte   BEGRFM53 144-145
  int    BEGRFY53 146-149
  byte   ENDRFD53 150-151
  byte   ENDRFM53 152-153
  int    ENDRFY53 154-157
  byte   ENDRFD98 158-159
  byte   ENDRFM98 160-161
  int    ENDRFY98 162-165
  byte   KEYNESS 166-166
  byte   INSCOP31 167-167
  byte   INSCOP42 168-168
  byte   INSCOP53 169-169
  byte   INSCOP98 170-170
  byte   INSC1231 171-171
  byte   INSCOPE 172-172
  byte   ELGRND31 173-173
  byte   ELGRND42 174-174
  byte   ELGRND53 175-175
  byte   ELGRND98 176-176
  byte   ELIGIBLE 177-177
  byte   PSTATS31 178-179
  byte   PSTATS42 180-181
  byte   PSTATS53 182-183
  str    RURSLT31 184-185
  str    RURSLT42 186-187
  str    RURSLT53 188-189
  byte   R2FLAG 190-191
  byte   AGE31X 192-193
  byte   AGE42X 194-195
  byte   AGE53X 196-197
  byte   AGE98X 198-199
  byte   DOBMM 200-201
  int    DOBYY 202-205
  byte   SEX 206-206
  byte   RACEX 207-207
  byte   RACETHNX 208-208
  byte   HISPANX 209-209
  byte   HISPCAT 210-211
  byte   MARRY31X 212-213
  byte   MARRY42X 214-215
  byte   MARRY53X 216-217
  byte   MARRY98X 218-219
  int    SPOUID31 220-222
  int    SPOUID42 223-225
  int    SPOUID53 226-228
  int    SPOUID98 229-231
  byte   SPOUIN31 232-233
  byte   SPOUIN42 234-235
  byte   SPOUIN53 236-237
  byte   SPOUIN98 238-239
  byte   EDUCYR31 240-241
  byte   EDUCYR42 242-243
  byte   EDUCYR53 244-245
  byte   EDUCYR98 246-247
  byte   HIDEG31 248-249
  byte   HIDEG42 250-251
  byte   HIDEG53 252-253
  byte   HIDEG98 254-255
  byte   FTSTU31X 256-257
  byte   FTSTU42X 258-259
  byte   FTSTU53X 260-261
  byte   FTSTU98X 262-263
  byte   ACTDTY31 264-265
  byte   ACTDTY42 266-267
  byte   ACTDTY53 268-269
  byte   DIDSERVE 270-271
  byte   VETPVIET 272-273
  byte   VETVIET 274-275
  byte   VETKOR 276-277
  byte   VETWW 278-279
  byte   VETOTH 280-281
  byte   RFREL31X 282-283
  byte   RFREL42X 284-285
  byte   RFREL53X 286-287
  byte   RFREL98X 288-289
  int    MOPID31X 290-292
  int    MOPID42X 293-295
  int    MOPID53X 296-298
  int    DAPID31X 299-301
  int    DAPID42X 302-304
  int    DAPID53X 305-307
  byte   SSIDIS98 308-309
  byte   AFDC98 310-311
  byte   FILEDR98 312-313
  byte   WILFIL98 314-315
  byte   FLSTAT98 316-317
  byte   FILER98 318-319
  byte   JTINRU98 320-321
  int    JNTPID98 322-324
  byte   CLMDEP98 325-326
  byte   DEPDNT98 327-328
  byte   DPINRU98 329-330
  byte   DPOTSD98 331-332
  byte   TAXFRM98 333-334
  byte   DEDUCT98 335-336
  byte   ITMEXP98 337-338
  double MEXAMT98 339-346
  double NTMDED98 347-354
  double TOTDED98 355-363
  byte   CLMHIP98 364-365
  byte   ELDISC98 366-367
  byte   EICRDT98 368-369
  int    UNEMTX98 370-372
  int    INTRTX98 373-375
  int    SSECTX98 376-378
  int    IRATAX98 379-381
  byte   FOODST98 382-383
  byte   FOODMN98 384-385
  double FOODCT98 386-391
  double FOODVL98 392-397
  double TTLP98X 398-406
  byte   POVCAT98 407-407
  double WAGEP98X 408-416
  byte   WAGIMP98 417-417
  double BUSNP98X 418-427
  byte   BUSIMP98 428-428
  double FARMP98X 429-437
  byte   FARIMP98 438-438
  double UNEMP98X 439-446
  byte   UNEIMP98 447-447
  double WCMPP98X 448-455
  byte   WCPIMP98 456-456
  double INTRP98X 457-464
  byte   INTIMP98 465-465
  double DIVDP98X 466-473
  byte   DIVIMP98 474-474
  double SALEP98X 475-483
  byte   SALIMP98 484-484
  double PENSP98X 485-492
  byte   PENIMP98 493-493
  double SSECP98X 494-501
  byte   SSCIMP98 502-502
  double TRSTP98X 503-511
  byte   TRTIMP98 512-512
  double VETSP98X 513-520
  byte   VETIMP98 521-521
  double IRASP98X 522-529
  byte   IRAIMP98 530-530
  double REFDP98X 531-538
  byte   REFIMP98 539-539
  double ALIMP98X 540-547
  byte   ALIIMP98 548-548
  double CHLDP98X 549-556
  byte   CHLIMP98 557-557
  double CASHP98X 558-565
  byte   CSHIMP98 566-566
  double SSIP98X 567-574
  byte   SSIIMP98 575-575
  double PUBP98X 576-583
  byte   PUBIMP98 584-584
  double OTHRP98X 585-592
  byte   OTHIMP98 593-593
  byte   EMPST31 594-595
  byte   EMPST42 596-597
  byte   EMPST53 598-599
  byte   RNDFLG31 600-601
  byte   MORJOB31 602-603
  byte   MORJOB42 604-605
  byte   MORJOB53 606-607
  byte   EVRWRK 608-609
  double HRWG31X 610-615
  double HRWG42X 616-621
  double HRWG53X 622-627
  byte   HRWGIM31 628-628
  byte   HRWGIM42 629-629
  byte   HRWGIM53 630-630
  byte   HRHOW31 631-632
  byte   HRHOW42 633-634
  byte   HRHOW53 635-636
  int    HOUR31 637-639
  int    HOUR42 640-642
  int    HOUR53 643-645
  byte   SELFCM31 646-647
  byte   SELFCM42 648-649
  byte   SELFCM53 650-651
  byte   DISVW31X 652-653
  byte   DISVW42X 654-655
  byte   DISVW53X 656-657
  byte   CHOIC31 658-659
  byte   CHOIC42 660-661
  byte   CHOIC53 662-663
  byte   CIND31 664-665
  byte   CIND42 666-667
  byte   CIND53 668-669
  int    NUMEMP31 670-672
  int    NUMEMP42 673-675
  int    NUMEMP53 676-678
  byte   MORE31 679-680
  byte   MORE42 681-682
  byte   MORE53 683-684
  byte   UNION31 685-686
  byte   UNION42 687-688
  byte   UNION53 689-690
  byte   NWK31 691-692
  byte   NWK42 693-694
  byte   NWK53 695-696
  byte   CHGJ3142 697-698
  byte   CHGJ4253 699-700
  byte   YCHJ3142 701-702
  byte   YCHJ4253 703-704
  byte   STJBMM31 705-706
  byte   STJBDD31 707-708
  int    STJBYY31 709-712
  byte   STJBMM42 713-714
  byte   STJBDD42 715-716
  int    STJBYY42 717-720
  byte   STJBMM53 721-722
  byte   STJBDD53 723-724
  int    STJBYY53 725-728
  byte   EVRETIRE 729-730
  byte   COCCP31 731-732
  byte   COCCP42 733-734
  byte   COCCP53 735-736
  byte   BGNWK31 737-738
  byte   BGNWK42 739-740
  byte   BGNWK53 741-742
  byte   ENDWK31 743-744
  byte   ENDWK42 745-746
  byte   ENDWK53 747-748
  byte   PAYVAC31 749-750
  byte   PAYVAC42 751-752
  byte   PAYVAC53 753-754
  byte   SICPAY31 755-756
  byte   SICPAY42 757-758
  byte   SICPAY53 759-760
  byte   PAYDR31 761-762
  byte   PAYDR42 763-764
  byte   PAYDR53 765-766
  byte   RETPLN31 767-768
  byte   RETPLN42 769-770
  byte   RETPLN53 771-772
  byte   SHFTWK31 773-774
  byte   SHFTWK42 775-776
  byte   SHFTWK53 777-778
  byte   BSNTY31 779-780
  byte   BSNTY42 781-782
  byte   BSNTY53 783-784
  byte   JOBORG31 785-786
  byte   JOBORG42 787-788
  byte   JOBORG53 789-790
  byte   HELD31X 791-792
  byte   HELD42X 793-794
  byte   HELD53X 795-796
  byte   OFFER31X 797-798
  byte   OFFER42X 799-800
  byte   OFFER53X 801-802
  byte   CHJA98X 803-804
  byte   CHFE98X 805-806
  byte   CHMA98X 807-808
  byte   CHAP98X 809-810
  byte   CHMY98X 811-812
  byte   CHJU98X 813-814
  byte   CHJL98X 815-816
  byte   CHAU98X 817-818
  byte   CHSE98X 819-820
  byte   CHOC98X 821-822
  byte   CHNO98X 823-824
  byte   CHDE98X 825-826
  byte   MCRJA98 827-828
  byte   MCRFE98 829-830
  byte   MCRMA98 831-832
  byte   MCRAP98 833-834
  byte   MCRMY98 835-836
  byte   MCRJU98 837-838
  byte   MCRJL98 839-840
  byte   MCRAU98 841-842
  byte   MCRSE98 843-844
  byte   MCROC98 845-846
  byte   MCRNO98 847-848
  byte   MCRDE98 849-850
  byte   MCRJA98X 851-852
  byte   MCRFE98X 853-854
  byte   MCRMA98X 855-856
  byte   MCRAP98X 857-858
  byte   MCRMY98X 859-860
  byte   MCRJU98X 861-862
  byte   MCRJL98X 863-864
  byte   MCRAU98X 865-866
  byte   MCRSE98X 867-868
  byte   MCROC98X 869-870
  byte   MCRNO98X 871-872
  byte   MCRDE98X 873-874
  byte   MCDJA98 875-876
  byte   MCDFE98 877-878
  byte   MCDMA98 879-880
  byte   MCDAP98 881-882
  byte   MCDMY98 883-884
  byte   MCDJU98 885-886
  byte   MCDJL98 887-888
  byte   MCDAU98 889-890
  byte   MCDSE98 891-892
  byte   MCDOC98 893-894
  byte   MCDNO98 895-896
  byte   MCDDE98 897-898
  byte   MCDJA98X 899-900
  byte   MCDFE98X 901-902
  byte   MCDMA98X 903-904
  byte   MCDAP98X 905-906
  byte   MCDMY98X 907-908
  byte   MCDJU98X 909-910
  byte   MCDJL98X 911-912
  byte   MCDAU98X 913-914
  byte   MCDSE98X 915-916
  byte   MCDOC98X 917-918
  byte   MCDNO98X 919-920
  byte   MCDDE98X 921-922
  byte   OPAJA98 923-924
  byte   OPAFE98 925-926
  byte   OPAMA98 927-928
  byte   OPAAP98 929-930
  byte   OPAMY98 931-932
  byte   OPAJU98 933-934
  byte   OPAJL98 935-936
  byte   OPAAU98 937-938
  byte   OPASE98 939-940
  byte   OPAOC98 941-942
  byte   OPANO98 943-944
  byte   OPADE98 945-946
  byte   OPBJA98 947-948
  byte   OPBFE98 949-950
  byte   OPBMA98 951-952
  byte   OPBAP98 953-954
  byte   OPBMY98 955-956
  byte   OPBJU98 957-958
  byte   OPBJL98 959-960
  byte   OPBAU98 961-962
  byte   OPBSE98 963-964
  byte   OPBOC98 965-966
  byte   OPBNO98 967-968
  byte   OPBDE98 969-970
  byte   STAJA98 971-972
  byte   STAFE98 973-974
  byte   STAMA98 975-976
  byte   STAAP98 977-978
  byte   STAMY98 979-980
  byte   STAJU98 981-982
  byte   STAJL98 983-984
  byte   STAAU98 985-986
  byte   STASE98 987-988
  byte   STAOC98 989-990
  byte   STANO98 991-992
  byte   STADE98 993-994
  byte   PUBJA98X 995-996
  byte   PUBFE98X 997-998
  byte   PUBMA98X 999-1000
  byte   PUBAP98X 1001-1002
  byte   PUBMY98X 1003-1004
  byte   PUBJU98X 1005-1006
  byte   PUBJL98X 1007-1008
  byte   PUBAU98X 1009-1010
  byte   PUBSE98X 1011-1012
  byte   PUBOC98X 1013-1014
  byte   PUBNO98X 1015-1016
  byte   PUBDE98X 1017-1018
  byte   PEGJA98 1019-1020
  byte   PEGFE98 1021-1022
  byte   PEGMA98 1023-1024
  byte   PEGAP98 1025-1026
  byte   PEGMY98 1027-1028
  byte   PEGJU98 1029-1030
  byte   PEGJL98 1031-1032
  byte   PEGAU98 1033-1034
  byte   PEGSE98 1035-1036
  byte   PEGOC98 1037-1038
  byte   PEGNO98 1039-1040
  byte   PEGDE98 1041-1042
  byte   PDKJA98 1043-1044
  byte   PDKFE98 1045-1046
  byte   PDKMA98 1047-1048
  byte   PDKAP98 1049-1050
  byte   PDKMY98 1051-1052
  byte   PDKJU98 1053-1054
  byte   PDKJL98 1055-1056
  byte   PDKAU98 1057-1058
  byte   PDKSE98 1059-1060
  byte   PDKOC98 1061-1062
  byte   PDKNO98 1063-1064
  byte   PDKDE98 1065-1066
  byte   PNGJA98 1067-1068
  byte   PNGFE98 1069-1070
  byte   PNGMA98 1071-1072
  byte   PNGAP98 1073-1074
  byte   PNGMY98 1075-1076
  byte   PNGJU98 1077-1078
  byte   PNGJL98 1079-1080
  byte   PNGAU98 1081-1082
  byte   PNGSE98 1083-1084
  byte   PNGOC98 1085-1086
  byte   PNGNO98 1087-1088
  byte   PNGDE98 1089-1090
  byte   POGJA98 1091-1092
  byte   POGFE98 1093-1094
  byte   POGMA98 1095-1096
  byte   POGAP98 1097-1098
  byte   POGMY98 1099-1100
  byte   POGJU98 1101-1102
  byte   POGJL98 1103-1104
  byte   POGAU98 1105-1106
  byte   POGSE98 1107-1108
  byte   POGOC98 1109-1110
  byte   POGNO98 1111-1112
  byte   POGDE98 1113-1114
  byte   PRSJA98 1115-1116
  byte   PRSFE98 1117-1118
  byte   PRSMA98 1119-1120
  byte   PRSAP98 1121-1122
  byte   PRSMY98 1123-1124
  byte   PRSJU98 1125-1126
  byte   PRSJL98 1127-1128
  byte   PRSAU98 1129-1130
  byte   PRSSE98 1131-1132
  byte   PRSOC98 1133-1134
  byte   PRSNO98 1135-1136
  byte   PRSDE98 1137-1138
  byte   POUJA98 1139-1140
  byte   POUFE98 1141-1142
  byte   POUMA98 1143-1144
  byte   POUAP98 1145-1146
  byte   POUMY98 1147-1148
  byte   POUJU98 1149-1150
  byte   POUJL98 1151-1152
  byte   POUAU98 1153-1154
  byte   POUSE98 1155-1156
  byte   POUOC98 1157-1158
  byte   POUNO98 1159-1160
  byte   POUDE98 1161-1162
  byte   PRIJA98 1163-1164
  byte   PRIFE98 1165-1166
  byte   PRIMA98 1167-1168
  byte   PRIAP98 1169-1170
  byte   PRIMY98 1171-1172
  byte   PRIJU98 1173-1174
  byte   PRIJL98 1175-1176
  byte   PRIAU98 1177-1178
  byte   PRISE98 1179-1180
  byte   PRIOC98 1181-1182
  byte   PRINO98 1183-1184
  byte   PRIDE98 1185-1186
  byte   HPEJA98 1187-1188
  byte   HPEFE98 1189-1190
  byte   HPEMA98 1191-1192
  byte   HPEAP98 1193-1194
  byte   HPEMY98 1195-1196
  byte   HPEJU98 1197-1198
  byte   HPEJL98 1199-1200
  byte   HPEAU98 1201-1202
  byte   HPESE98 1203-1204
  byte   HPEOC98 1205-1206
  byte   HPENO98 1207-1208
  byte   HPEDE98 1209-1210
  byte   HPDJA98 1211-1212
  byte   HPDFE98 1213-1214
  byte   HPDMA98 1215-1216
  byte   HPDAP98 1217-1218
  byte   HPDMY98 1219-1220
  byte   HPDJU98 1221-1222
  byte   HPDJL98 1223-1224
  byte   HPDAU98 1225-1226
  byte   HPDSE98 1227-1228
  byte   HPDOC98 1229-1230
  byte   HPDNO98 1231-1232
  byte   HPDDE98 1233-1234
  byte   HPNJA98 1235-1236
  byte   HPNFE98 1237-1238
  byte   HPNMA98 1239-1240
  byte   HPNAP98 1241-1242
  byte   HPNMY98 1243-1244
  byte   HPNJU98 1245-1246
  byte   HPNJL98 1247-1248
  byte   HPNAU98 1249-1250
  byte   HPNSE98 1251-1252
  byte   HPNOC98 1253-1254
  byte   HPNNO98 1255-1256
  byte   HPNDE98 1257-1258
  byte   HPOJA98 1259-1260
  byte   HPOFE98 1261-1262
  byte   HPOMA98 1263-1264
  byte   HPOAP98 1265-1266
  byte   HPOMY98 1267-1268
  byte   HPOJU98 1269-1270
  byte   HPOJL98 1271-1272
  byte   HPOAU98 1273-1274
  byte   HPOSE98 1275-1276
  byte   HPOOC98 1277-1278
  byte   HPONO98 1279-1280
  byte   HPODE98 1281-1282
  byte   HPSJA98 1283-1284
  byte   HPSFE98 1285-1286
  byte   HPSMA98 1287-1288
  byte   HPSAP98 1289-1290
  byte   HPSMY98 1291-1292
  byte   HPSJU98 1293-1294
  byte   HPSJL98 1295-1296
  byte   HPSAU98 1297-1298
  byte   HPSSE98 1299-1300
  byte   HPSOC98 1301-1302
  byte   HPSNO98 1303-1304
  byte   HPSDE98 1305-1306
  byte   HPRJA98 1307-1308
  byte   HPRFE98 1309-1310
  byte   HPRMA98 1311-1312
  byte   HPRAP98 1313-1314
  byte   HPRMY98 1315-1316
  byte   HPRJU98 1317-1318
  byte   HPRJL98 1319-1320
  byte   HPRAU98 1321-1322
  byte   HPRSE98 1323-1324
  byte   HPROC98 1325-1326
  byte   HPRNO98 1327-1328
  byte   HPRDE98 1329-1330
  byte   INSJA98X 1331-1332
  byte   INSFE98X 1333-1334
  byte   INSMA98X 1335-1336
  byte   INSAP98X 1337-1338
  byte   INSMY98X 1339-1340
  byte   INSJU98X 1341-1342
  byte   INSJL98X 1343-1344
  byte   INSAU98X 1345-1346
  byte   INSSE98X 1347-1348
  byte   INSOC98X 1349-1350
  byte   INSNO98X 1351-1352
  byte   INSDE98X 1353-1354
  byte   PRVEV98 1355-1355
  byte   CHPEV98 1356-1356
  byte   MCREV98 1357-1357
  byte   MCDEV98 1358-1358
  byte   OPAEV98 1359-1359
  byte   OPBEV98 1360-1360
  byte   UNINS98 1361-1361
  byte   INSCOV98 1362-1362
  byte   RTHLTH31 1363-1364
  byte   RTHLTH42 1365-1366
  byte   RTHLTH53 1367-1368
  byte   RTPROX31 1369-1370
  byte   RTPROX42 1371-1372
  byte   RTPROX53 1373-1374
  byte   MNHLTH31 1375-1376
  byte   MNHLTH42 1377-1378
  byte   MNHLTH53 1379-1380
  byte   MNPROX31 1381-1382
  byte   MNPROX42 1383-1384
  byte   MNPROX53 1385-1386
  byte   IADLHP31 1387-1388
  byte   IADLHP42 1389-1390
  byte   IADLHP53 1391-1392
  byte   ADLHLP31 1393-1394
  byte   ADLHLP42 1395-1396
  byte   ADLHLP53 1397-1398
  byte   AIDHLP31 1399-1400
  byte   AIDHLP53 1401-1402
  byte   WLKLIM31 1403-1404
  byte   WLKLIM53 1405-1406
  byte   LFTDIF31 1407-1408
  byte   LFTDIF53 1409-1410
  byte   STPDIF31 1411-1412
  byte   STPDIF53 1413-1414
  byte   WLKDIF31 1415-1416
  byte   WLKDIF53 1417-1418
  byte   MILDIF31 1419-1420
  byte   MILDIF53 1421-1422
  byte   STNDIF31 1423-1424
  byte   STNDIF53 1425-1426
  byte   BENDIF31 1427-1428
  byte   BENDIF53 1429-1430
  byte   RCHDIF31 1431-1432
  byte   RCHDIF53 1433-1434
  byte   FNGRDF31 1435-1436
  byte   FNGRDF53 1437-1438
  byte   ACTLIM31 1439-1440
  byte   ACTLIM53 1441-1442
  byte   WRKLIM31 1443-1444
  byte   WRKLIM53 1445-1446
  byte   HSELIM31 1447-1448
  byte   HSELIM53 1449-1450
  byte   SCHLIM31 1451-1452
  byte   SCHLIM53 1453-1454
  byte   UNABLE31 1455-1456
  byte   UNABLE53 1457-1458
  byte   SOCLIM31 1459-1460
  byte   SOCLIM53 1461-1462
  byte   COGLIM31 1463-1464
  byte   COGLIM53 1465-1466
  byte   WRGLAS42 1467-1468
  byte   SEEDIF42 1469-1470
  byte   BLIND42 1471-1472
  byte   READNW42 1473-1474
  byte   RECPEP42 1475-1476
  byte   VISION42 1477-1478
  byte   HEARAD42 1479-1480
  byte   HEARDI42 1481-1482
  byte   DEAF42 1483-1484
  byte   HEARMO42 1485-1486
  byte   HEARSM42 1487-1488
  byte   HEARNG42 1489-1490
  byte   ANYLIM98 1491-1492
  byte   LIMACT42 1493-1494
  byte   PLYLIM42 1495-1496
  byte   CANTPL42 1497-1498
  byte   SPCPRO42 1499-1500
  byte   DPTSHT42 1501-1502
  byte   NUMDPT42 1503-1504
  byte   POLSHT42 1505-1506
  byte   NUMPOL42 1507-1508
  byte   MMRSHT42 1509-1510
  byte   HEPSHT42 1511-1512
  byte   MOMPRO42 1513-1514
  byte   DADPRO42 1515-1516
  byte   UNHAP42 1517-1518
  byte   SCHLBH42 1519-1520
  byte   HAVFUN42 1521-1522
  byte   ADUPRO42 1523-1524
  byte   NERVAF42 1525-1526
  byte   SIBPRO42 1527-1528
  byte   KIDPRO42 1529-1530
  byte   SPRPRO42 1531-1532
  byte   SCHPRO42 1533-1534
  byte   HOMEBH42 1535-1536
  byte   TRBLE42 1537-1538
  byte   SPCSCH42 1539-1540
  byte   SPECED42 1541-1542
  byte   SPCHTH42 1543-1544
  byte   PSYCNS42 1545-1546
  byte   OCUPTH42 1547-1548
  byte   VOCSVC42 1549-1550
  byte   TUTOR42 1551-1552
  byte   READIN42 1553-1554
  byte   PHYTHR42 1555-1556
  byte   LIFSKL42 1557-1558
  byte   FAMCNS42 1559-1560
  byte   RECTHR42 1561-1562
  byte   OTHSVC42 1563-1564
  byte   CANTSC42 1565-1566
  byte   LMOACT42 1567-1568
  byte   HLTHY42 1569-1570
  byte   NTHLTH42 1571-1572
  byte   GETSIC42 1573-1574
  byte   HGTFT42 1575-1576
  byte   HGTIN42 1577-1578
  int    WGTLB42 1579-1581
  byte   WGTOZ42 1582-1583
  byte   CHLIM42 1584-1585
  byte   DENTCK98 1586-1587
  byte   BLDPCK98 1588-1589
  byte   CHOLCK98 1590-1591
  byte   PHYSCL98 1592-1593
  byte   FLUSHT98 1594-1595
  byte   WRDENT98 1596-1597
  byte   LOSTEE98 1598-1599
  byte   PROSEX98 1600-1601
  byte   PAPSMR98 1602-1603
  byte   BRSTEX98 1604-1605
  byte   MAMGRM98 1606-1607
  byte   ALTCAR98 1608-1609
  int    ALTCVS98 1610-1612
  byte   ALTCVE98 1613-1614
  long   ALTCRE98 1615-1619
  byte   ALTCRX98 1620-1621
  byte   INSALT98 1622-1623
  int    PERINS98 1624-1626
  int    PRALTX98 1627-1630
  byte   PRALTE98 1631-1632
  byte   ACUPNC98 1633-1634
  byte   NUTRIT98 1635-1636
  byte   MASAGE98 1637-1638
  byte   HERBAL98 1639-1640
  byte   BIOFDB98 1641-1642
  byte   MEDITA98 1643-1644
  byte   HOMEO98 1645-1646
  byte   SPIRTL98 1647-1648
  byte   HYPNO98 1649-1650
  byte   TRADIT98 1651-1652
  byte   ALTOTH98 1653-1654
  byte   MASTHE98 1655-1656
  byte   ACPTHE98 1657-1658
  byte   MDTRT98 1659-1660
  byte   NURTRT98 1661-1662
  byte   HOMEMD98 1663-1664
  byte   CHIRO98 1665-1666
  byte   CLERGY98 1667-1668
  byte   HERBTR98 1669-1670
  byte   OTHALT98 1671-1672
  byte   ALTCSP98 1673-1674
  byte   DSCALT98 1675-1676
  byte   REFRMD98 1677-1678
  byte   WHRCAR98 1679-1680
  byte   WHOCAR98 1681-1682
  byte   DAYCAR98 1683-1684
  long   TOTTCH98 1685-1690
  long   TOTEXP98 1691-1696
  long   TOTSLF98 1697-1701
  long   TOTMCR98 1702-1707
  long   TOTMCD98 1708-1713
  long   TOTPRV98 1714-1719
  long   TOTVA98 1720-1724
  long   TOTCHM98 1725-1729
  long   TOTOFD98 1730-1734
  long   TOTSTL98 1735-1739
  long   TOTWCP98 1740-1744
  long   TOTOPR98 1745-1750
  long   TOTOPU98 1751-1755
  long   TOTOSR98 1756-1760
  int    OBTOTV98 1761-1763
  long   OBVTCH98 1764-1768
  long   OBVEXP98 1769-1773
  long   OBVSLF98 1774-1778
  long   OBVMCR98 1779-1783
  long   OBVMCD98 1784-1788
  long   OBVPRV98 1789-1793
  long   OBVVA98 1794-1798
  int    OBVCHM98 1799-1802
  long   OBVOFD98 1803-1807
  int    OBVSTL98 1808-1811
  long   OBVWCP98 1812-1816
  int    OBVOPR98 1817-1820
  int    OBVOPU98 1821-1824
  int    OBVOSR98 1825-1828
  int    OBDRV98 1829-1831
  long   OBDTCH98 1832-1836
  long   OBDEXP98 1837-1841
  long   OBDSLF98 1842-1846
  long   OBDMCR98 1847-1851
  long   OBDMCD98 1852-1856
  long   OBDPRV98 1857-1861
  int    OBDVA98 1862-1865
  int    OBDCHM98 1866-1869
  int    OBDOFD98 1870-1873
  int    OBDSTL98 1874-1877
  int    OBDWCP98 1878-1881
  int    OBDOPR98 1882-1885
  int    OBDOPU98 1886-1889
  int    OBDOSR98 1890-1893
  int    OBOTHV98 1894-1896
  long   OBOTCH98 1897-1901
  long   OBOEXP98 1902-1906
  int    OBOSLF98 1907-1910
  long   OBOMCR98 1911-1915
  long   OBOMCD98 1916-1920
  long   OBOPRV98 1921-1925
  int    OBOVA98 1926-1929
  int    OBOCHM98 1930-1933
  int    OBOOFD98 1934-1937
  int    OBOSTL98 1938-1941
  int    OBOWCP98 1942-1945
  int    OBOOPR98 1946-1949
  int    OBOOPU98 1950-1952
  int    OBOOSR98 1953-1956
  int    OBCHIR98 1957-1959
  int    OBCTCH98 1960-1963
  int    OBCEXP98 1964-1967
  int    OBCSLF98 1968-1971
  int    OBCMCR98 1972-1975
  int    OBCMCD98 1976-1979
  int    OBCPRV98 1980-1983
  int    OBCVA98 1984-1986
  byte   OBCCHM98 1987-1987
  byte   OBCOFD98 1988-1988
  byte   OBCSTL98 1989-1989
  int    OBCWCP98 1990-1993
  int    OBCOPR98 1994-1996
  byte   OBCOPU98 1997-1997
  int    OBCOSR98 1998-2001
  int    OBNURS98 2002-2004
  long   OBNTCH98 2005-2009
  long   OBNEXP98 2010-2014
  int    OBNSLF98 2015-2018
  long   OBNMCR98 2019-2023
  int    OBNMCD98 2024-2027
  long   OBNPRV98 2028-2032
  int    OBNVA98 2033-2035
  int    OBNCHM98 2036-2038
  int    OBNOFD98 2039-2041
  int    OBNSTL98 2042-2045
  int    OBNWCP98 2046-2048
  int    OBNOPR98 2049-2052
  int    OBNOPU98 2053-2055
  int    OBNOSR98 2056-2059
  byte   OBOPTO98 2060-2060
  int    OBETCH98 2061-2064
  int    OBEEXP98 2065-2068
  int    OBESLF98 2069-2072
  int    OBEMCR98 2073-2076
  int    OBEMCD98 2077-2079
  int    OBEPRV98 2080-2083
  int    OBEVA98 2084-2086
  byte   OBECHM98 2087-2088
  byte   OBEOFD98 2089-2090
  int    OBESTL98 2091-2093
  byte   OBEWCP98 2094-2094
  int    OBEOPR98 2095-2097
  byte   OBEOPU98 2098-2098
  int    OBEOSR98 2099-2101
  byte   OBASST98 2102-2103
  int    OBATCH98 2104-2107
  int    OBAEXP98 2108-2111
  int    OBASLF98 2112-2114
  int    OBAMCR98 2115-2118
  int    OBAMCD98 2119-2122
  int    OBAPRV98 2123-2126
  int    OBAVA98 2127-2129
  int    OBACHM98 2130-2132
  int    OBAOFD98 2133-2135
  int    OBASTL98 2136-2138
  int    OBAWCP98 2139-2141
  int    OBAOPR98 2142-2144
  byte   OBAOPU98 2145-2146
  int    OBAOSR98 2147-2149
  int    OBTHER98 2150-2152
  long   OBTTCH98 2153-2157
  long   OBTEXP98 2158-2162
  int    OBTSLF98 2163-2166
  int    OBTMCR98 2167-2170
  int    OBTMCD98 2171-2174
  int    OBTPRV98 2175-2178
  int    OBTVA98 2179-2181
  int    OBTCHM98 2182-2184
  int    OBTOFD98 2185-2187
  int    OBTSTL98 2188-2190
  int    OBTWCP98 2191-2194
  int    OBTOPR98 2195-2198
  byte   OBTOPU98 2199-2199
  int    OBTOSR98 2200-2203
  int    OPTOTV98 2204-2206
  long   OPFTCH98 2207-2211
  long   OPFEXP98 2212-2216
  long   OPFSLF98 2217-2221
  long   OPFMCR98 2222-2226
  long   OPFMCD98 2227-2231
  long   OPFPRV98 2232-2236
  long   OPFVA98 2237-2241
  int    OPFCHM98 2242-2245
  long   OPFOFD98 2246-2250
  int    OPFSTL98 2251-2254
  long   OPFWCP98 2255-2259
  int    OPFOPR98 2260-2263
  int    OPFOPU98 2264-2267
  int    OPFOSR98 2268-2271
  long   OPDEXP98 2272-2276
  long   OPDTCH98 2277-2281
  int    OPDSLF98 2282-2285
  int    OPDMCR98 2286-2289
  int    OPDMCD98 2290-2293
  long   OPDPRV98 2294-2298
  int    OPDVA98 2299-2301
  int    OPDCHM98 2302-2304
  int    OPDOFD98 2305-2307
  int    OPDSTL98 2308-2310
  int    OPDWCP98 2311-2314
  int    OPDOPR98 2315-2318
  int    OPDOPU98 2319-2321
  int    OPDOSR98 2322-2325
  int    OPDRV98 2326-2328
  long   OPVTCH98 2329-2333
  long   OPVEXP98 2334-2338
  long   OPVSLF98 2339-2343
  long   OPVMCR98 2344-2348
  long   OPVMCD98 2349-2353
  long   OPVPRV98 2354-2358
  int    OPVVA98 2359-2362
  int    OPVCHM98 2363-2366
  long   OPVOFD98 2367-2371
  int    OPVSTL98 2372-2375
  long   OPVWCP98 2376-2380
  int    OPVOPR98 2381-2384
  int    OPVOPU98 2385-2388
  int    OPVOSR98 2389-2392
  long   OPSEXP98 2393-2397
  long   OPSTCH98 2398-2402
  int    OPSSLF98 2403-2406
  int    OPSMCR98 2407-2410
  int    OPSMCD98 2411-2414
  long   OPSPRV98 2415-2419
  int    OPSVA98 2420-2422
  int    OPSCHM98 2423-2425
  byte   OPSOFD98 2426-2427
  byte   OPSSTL98 2428-2429
  int    OPSWCP98 2430-2433
  int    OPSOPR98 2434-2437
  int    OPSOPU98 2438-2440
  int    OPSOSR98 2441-2444
  int    OPOTHV98 2445-2447
  long   OPOTCH98 2448-2452
  long   OPOEXP98 2453-2457
  int    OPOSLF98 2458-2461
  long   OPOMCR98 2462-2466
  long   OPOMCD98 2467-2471
  long   OPOPRV98 2472-2476
  long   OPOVA98 2477-2481
  int    OPOCHM98 2482-2484
  int    OPOOFD98 2485-2488
  int    OPOSTL98 2489-2492
  int    OPOWCP98 2493-2496
  int    OPOOPR98 2497-2500
  int    OPOOPU98 2501-2503
  int    OPOOSR98 2504-2507
  long   OPPEXP98 2508-2512
  long   OPPTCH98 2513-2517
  int    OPPSLF98 2518-2520
  int    OPPMCR98 2521-2524
  int    OPPMCD98 2525-2528
  long   OPPPRV98 2529-2533
  int    OPPVA98 2534-2536
  byte   OPPCHM98 2537-2538
  int    OPPOFD98 2539-2541
  int    OPPSTL98 2542-2544
  int    OPPWCP98 2545-2547
  int    OPPOPR98 2548-2551
  int    OPPOPU98 2552-2554
  int    OPPOSR98 2555-2557
  int    AMCHIR98 2558-2560
  int    AMCTCH98 2561-2564
  int    AMCEXP98 2565-2568
  int    AMCSLF98 2569-2572
  int    AMCMCR98 2573-2576
  int    AMCMCD98 2577-2580
  int    AMCPRV98 2581-2584
  int    AMCVA98 2585-2587
  byte   AMCCHM98 2588-2588
  byte   AMCOFD98 2589-2589
  byte   AMCSTL98 2590-2590
  int    AMCWCP98 2591-2594
  int    AMCOPR98 2595-2597
  byte   AMCOPU98 2598-2598
  int    AMCOSR98 2599-2602
  int    AMNURS98 2603-2605
  long   AMNTCH98 2606-2610
  long   AMNEXP98 2611-2615
  int    AMNSLF98 2616-2619
  long   AMNMCR98 2620-2624
  long   AMNMCD98 2625-2629
  long   AMNPRV98 2630-2634
  int    AMNVA98 2635-2638
  int    AMNCHM98 2639-2641
  int    AMNOFD98 2642-2644
  int    AMNSTL98 2645-2648
  int    AMNWCP98 2649-2651
  int    AMNOPR98 2652-2655
  int    AMNOPU98 2656-2658
  int    AMNOSR98 2659-2662
  byte   AMOPTO98 2663-2663
  int    AMETCH98 2664-2667
  int    AMEEXP98 2668-2671
  int    AMESLF98 2672-2675
  int    AMEMCR98 2676-2679
  int    AMEMCD98 2680-2682
  int    AMEPRV98 2683-2686
  int    AMEVA98 2687-2689
  byte   AMECHM98 2690-2691
  int    AMEOFD98 2692-2694
  int    AMESTL98 2695-2697
  byte   AMEWCP98 2698-2698
  int    AMEOPR98 2699-2701
  byte   AMEOPU98 2702-2702
  int    AMEOSR98 2703-2705
  byte   AMASST98 2706-2707
  long   AMATCH98 2708-2712
  long   AMAEXP98 2713-2717
  int    AMASLF98 2718-2720
  int    AMAMCR98 2721-2724
  int    AMAMCD98 2725-2728
  long   AMAPRV98 2729-2733
  int    AMAVA98 2734-2736
  int    AMACHM98 2737-2739
  int    AMAOFD98 2740-2742
  int    AMASTL98 2743-2745
  int    AMAWCP98 2746-2748
  int    AMAOPR98 2749-2751
  int    AMAOPU98 2752-2754
  int    AMAOSR98 2755-2757
  int    AMTHER98 2758-2760
  long   AMTTCH98 2761-2765
  long   AMTEXP98 2766-2770
  int    AMTSLF98 2771-2774
  int    AMTMCR98 2775-2778
  int    AMTMCD98 2779-2782
  long   AMTPRV98 2783-2787
  long   AMTVA98 2788-2792
  int    AMTCHM98 2793-2795
  int    AMTOFD98 2796-2799
  int    AMTSTL98 2800-2802
  int    AMTWCP98 2803-2806
  int    AMTOPR98 2807-2810
  byte   AMTOPU98 2811-2811
  int    AMTOSR98 2812-2815
  int    AMTOTC98 2816-2818
  int    AMDRC98 2819-2821
  byte   ERTOT98 2822-2823
  long   ERFTCH98 2824-2828
  long   ERFEXP98 2829-2833
  long   ERFSLF98 2834-2838
  int    ERFMCR98 2839-2842
  int    ERFMCD98 2843-2846
  long   ERFPRV98 2847-2851
  int    ERFVA98 2852-2855
  int    ERFCHM98 2856-2858
  int    ERFOFD98 2859-2862
  int    ERFSTL98 2863-2866
  int    ERFWCP98 2867-2870
  int    ERFOPR98 2871-2874
  int    ERFOPU98 2875-2878
  int    ERFOSR98 2879-2882
  int    ERDEXP98 2883-2886
  int    ERDTCH98 2887-2890
  int    ERDSLF98 2891-2894
  int    ERDMCR98 2895-2898
  int    ERDMCD98 2899-2902
  int    ERDPRV98 2903-2906
  int    ERDVA98 2907-2909
  int    ERDCHM98 2910-2912
  int    ERDOFD98 2913-2915
  int    ERDSTL98 2916-2918
  int    ERDWCP98 2919-2922
  int    ERDOPR98 2923-2925
  int    ERDOPU98 2926-2928
  int    ERDOSR98 2929-2932
  byte   IPZERO98 2933-2933
  long   ZIFTCH98 2934-2938
  long   ZIFEXP98 2939-2943
  int    ZIFSLF98 2944-2947
  int    ZIFMCR98 2948-2951
  long   ZIFMCD98 2952-2956
  int    ZIFPRV98 2957-2960
  int    ZIFVA98 2961-2963
  byte   ZIFCHM98 2964-2964
  int    ZIFOFD98 2965-2967
  byte   ZIFSTL98 2968-2968
  int    ZIFWCP98 2969-2972
  byte   ZIFOPR98 2973-2974
  byte   ZIFOPU98 2975-2975
  byte   ZIFOSR98 2976-2976
  int    ZIDEXP98 2977-2980
  int    ZIDTCH98 2981-2984
  int    ZIDSLF98 2985-2988
  int    ZIDMCR98 2989-2992
  int    ZIDMCD98 2993-2995
  int    ZIDPRV98 2996-2999
  byte   ZIDVA98 3000-3000
  byte   ZIDCHM98 3001-3001
  byte   ZIDOFD98 3002-3002
  byte   ZIDSTL98 3003-3003
  int    ZIDWCP98 3004-3007
  int    ZIDOPR98 3008-3010
  byte   ZIDOPU98 3011-3011
  byte   ZIDOSR98 3012-3012
  byte   IPDIS98 3013-3014
  long   IPFEXP98 3015-3020
  long   IPFTCH98 3021-3026
  long   IPFSLF98 3027-3031
  long   IPFMCR98 3032-3037
  long   IPFMCD98 3038-3042
  long   IPFPRV98 3043-3048
  long   IPFVA98 3049-3053
  long   IPFCHM98 3054-3058
  long   IPFOFD98 3059-3063
  int    IPFSTL98 3064-3067
  long   IPFWCP98 3068-3072
  long   IPFOPR98 3073-3078
  long   IPFOPU98 3079-3083
  long   IPFOSR98 3084-3088
  long   IPDEXP98 3089-3093
  long   IPDTCH98 3094-3098
  int    IPDSLF98 3099-3102
  long   IPDMCR98 3103-3107
  int    IPDMCD98 3108-3111
  long   IPDPRV98 3112-3116
  int    IPDVA98 3117-3119
  int    IPDCHM98 3120-3122
  int    IPDOFD98 3123-3125
  int    IPDSTL98 3126-3128
  long   IPDWCP98 3129-3133
  long   IPDOPR98 3134-3138
  int    IPDOPU98 3139-3142
  int    IPDOSR98 3143-3145
  int    IPNGTD98 3146-3148
  byte   DVTOT98 3149-3150
  long   DVTTCH98 3151-3155
  long   DVTEXP98 3156-3160
  long   DVTSLF98 3161-3165
  int    DVTMCR98 3166-3168
  long   DVTMCD98 3169-3173
  int    DVTPRV98 3174-3177
  int    DVTVA98 3178-3181
  int    DVTCHM98 3182-3185
  int    DVTOFD98 3186-3189
  int    DVTSTL98 3190-3193
  int    DVTWCP98 3194-3196
  int    DVTOPR98 3197-3200
  int    DVTOPU98 3201-3204
  int    DVTOSR98 3205-3208
  byte   DVGEN98 3209-3210
  long   DVGTCH98 3211-3215
  long   DVGEXP98 3216-3220
  long   DVGSLF98 3221-3225
  int    DVGMCR98 3226-3228
  int    DVGMCD98 3229-3232
  int    DVGPRV98 3233-3236
  int    DVGVA98 3237-3240
  int    DVGCHM98 3241-3244
  int    DVGOFD98 3245-3248
  int    DVGSTL98 3249-3252
  int    DVGWCP98 3253-3255
  int    DVGOPR98 3256-3259
  int    DVGOPU98 3260-3263
  int    DVGOSR98 3264-3267
  byte   DVORTH98 3268-3269
  long   DVOTCH98 3270-3274
  long   DVOEXP98 3275-3279
  long   DVOSLF98 3280-3284
  int    DVOMCR98 3285-3287
  long   DVOMCD98 3288-3292
  int    DVOPRV98 3293-3296
  byte   DVOVA98 3297-3297
  int    DVOCHM98 3298-3300
  int    DVOOFD98 3301-3304
  byte   DVOSTL98 3305-3305
  byte   DVOWCP98 3306-3307
  byte   DVOOPR98 3308-3308
  byte   DVOOPU98 3309-3309
  int    DVOOSR98 3310-3313
  int    HHTOTD98 3314-3316
  int    HHAGD98 3317-3319
  long   HHATCH98 3320-3325
  long   HHAEXP98 3326-3331
  long   HHASLF98 3332-3336
  long   HHAMCR98 3337-3341
  long   HHAMCD98 3342-3347
  long   HHAPRV98 3348-3352
  int    HHAVA98 3353-3355
  byte   HHACHM98 3356-3356
  int    HHAOFD98 3357-3360
  long   HHASTL98 3361-3365
  byte   HHAWCP98 3366-3366
  int    HHAOPR98 3367-3370
  byte   HHAOPU98 3371-3371
  byte   HHAOSR98 3372-3372
  int    HHINDD98 3373-3375
  long   HHNTCH98 3376-3380
  long   HHNEXP98 3381-3385
  long   HHNSLF98 3386-3390
  int    HHNMCR98 3391-3394
  long   HHNMCD98 3395-3399
  int    HHNPRV98 3400-3403
  byte   HHNVA98 3404-3404
  byte   HHNCHM98 3405-3405
  byte   HHNOFD98 3406-3406
  byte   HHNSTL98 3407-3407
  byte   HHNWCP98 3408-3409
  byte   HHNOPR98 3410-3410
  int    HHNOPU98 3411-3413
  byte   HHNOSR98 3414-3414
  int    HHINFD98 3415-3417
  int    VISEXP98 3418-3421
  int    VISTCH98 3422-3425
  int    VISSLF98 3426-3429
  int    VISMCR98 3430-3432
  int    VISMCD98 3433-3435
  int    VISPRV98 3436-3438
  int    VISVA98 3439-3441
  int    VISCHM98 3442-3444
  int    VISOFD98 3445-3448
  int    VISSTL98 3449-3451
  byte   VISWCP98 3452-3452
  int    VISOPR98 3453-3455
  int    VISOPU98 3456-3458
  int    VISOSR98 3459-3461
  long   OTHTCH98 3462-3466
  long   OTHEXP98 3467-3471
  long   OTHSLF98 3472-3476
  long   OTHMCR98 3477-3481
  int    OTHMCD98 3482-3485
  long   OTHPRV98 3486-3490
  long   OTHVA98 3491-3495
  int    OTHCHM98 3496-3498
  int    OTHOFD98 3499-3502
  int    OTHSTL98 3503-3506
  int    OTHWCP98 3507-3509
  int    OTHOPR98 3510-3513
  int    OTHOPU98 3514-3516
  int    OTHOSR98 3517-3519
  int    RXTOT98 3520-3522
  long   RXEXP98 3523-3527
  long   RXSLF98 3528-3532
  int    RXMCR98 3533-3536
  long   RXMCD98 3537-3541
  long   RXPRV98 3542-3546
  int    RXVA98 3547-3550
  int    RXCHM98 3551-3554
  int    RXOFD98 3555-3558
  int    RXSTL98 3559-3562
  int    RXWCP98 3563-3566
  int    RXOPR98 3567-3570
  int    RXOPU98 3571-3573
  int    RXOSR98 3574-3577
  double WTDPER98 3578-3589
  double WTFAMF98 3590-3601
  double WTCFAM98 3602-3613
  int    VARSTR98 3614-3616
  byte   VARPSU98 3617-3618
using H28.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL98 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID98 "FAMILY ID (STUDENT MERGED IN)-12/31/98";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR98 "RU LETTER AS OF 12/31/98";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE98 "RU SIZE AS OF 12/31/98";
label variable RUCLAS31 "RU FIELDED AS:STANDARD,NEW,STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD,NEW,STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS: STANDARD,NEW,STUDENT-R5/3";
label variable RUCLAS98 "RU FIELDED AS:STANDARD,NEW,STUD-12/31/98";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE98 "RU SIZE INCLUDING STUDENT AS OF 12/31/98";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable FYFAMTYP "CPS - FULL YEAR FAMILY TYPE";
label variable INRU1231 "PERSON WAS IN RU ON 12/31/98";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION98 "CENSUS REGION AS OF 12/31/98";
label variable MSA53 "MSA R5/3 STATUS";
label variable MSA98 "MSA AS OF 12/31/98";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS98 "REFERENCE PERSON AS OF 12/31/98";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP98 "1ST RESPONDENT INDICATOR AS OF 12/31/98";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY98 "WAS RESPONDENT A PROXY AS OF 12/31/98";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD98 "1998 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM98 "1998 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY98 "1998 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP98 "INSCOPE - R5/3 START THROUGH 12/31/98";
label variable INSC1231 "INSCOPE STATUS ON DECEMBER 31, 1998";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 1998";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND98 "ELIGIBILITY STATUS AS OF 12/31/98";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 1998";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable R2FLAG "FLAG:PERSON IS IN P3R2 RU W/INTV IN 1999";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE98X "AGE AS OF 12/31/98 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY98X "MARITAL STATUS-12/31/98 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID98 "SPOUSE ID - 12/31/98";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT R5/3";
label variable SPOUIN98 "MARITAL STATUS W/SPOUSE PRESENT-12/31/98";
label variable EDUCYR31 "COMPLETED YEARS OF EDUCATION - R3/1";
label variable EDUCYR42 "COMPLETED YEARS OF EDUCATION - R4/2";
label variable EDUCYR53 "COMPLETED YEARS OF EDUCATION - R5/3";
label variable EDUCYR98 "COMPLETED YEARS OF EDUCATION - 12/31/98";
label variable HIDEG31 "HIGHEST DEGREE EARNED R3/1";
label variable HIDEG42 "HIGHEST DEGREE EARNED R4/2";
label variable HIDEG53 "HIGHEST DEGREE EARNED R5/3";
label variable HIDEG98 "HIGHEST DEGREE AS OF 12/31/98";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 R5/3";
label variable FTSTU98X "STUDENT STATUS IF AGES 17-23 - 12/31/98";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETPVIET "SERVED IN POST-VIETNAM ERA";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS R5/3 (EDIT/IMP)";
label variable RFREL98X "RELATION TO REF PERS 12/31/98 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS98 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC98 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR98 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL98 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT98 "PERSON S FILING STATUS";
label variable FILER98 "PRIMARY OR SECONDARY FILER";
label variable JTINRU98 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID98 "PID OF SECONDARY FILER";
label variable CLMDEP98 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT98 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU98 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD98 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM98 "TAX FORM PERSON WILL FILE";
label variable DEDUCT98 "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEXP98 "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MEXAMT98 "TOTAL AMOUNT FOR MEDICAL EXPENSES";
label variable NTMDED98 "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED98 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP98 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable ELDISC98 "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICRDT98 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTX98 "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTX98 "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTX98 "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRATAX98 "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODST98 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN98 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT98 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL98 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP98X "PERSON S TOTAL INCOME";
label variable POVCAT98 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP98X "PERSON S WAGE INCOME";
label variable WAGIMP98 "WAGE IMPUTATION FLAG";
label variable BUSNP98X "PERSON S BUSINESS INCOME";
label variable BUSIMP98 "BUSINESS INCOME IMPUTATION FLAG";
label variable FARMP98X "PERSON S FARM INCOME";
label variable FARIMP98 "FARM INCOME IMPUTATION FLAG";
label variable UNEMP98X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP98 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP98X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP98 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP98X "PERSON S INTEREST INCOME";
label variable INTIMP98 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP98X "PERSON S DIVIDEND INCOME";
label variable DIVIMP98 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP98X "PERSON S SALES INCOME";
label variable SALIMP98 "SALES INCOME IMPUTATION FLAG";
label variable PENSP98X "PERSON S PENSION INCOME";
label variable PENIMP98 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP98X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP98 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP98X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP98 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP98X "PERSON S VETERAN S INCOME";
label variable VETIMP98 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP98X "PERSON S IRA INCOME";
label variable IRAIMP98 "IRA INCOME IMPUTATION FLAG";
label variable REFDP98X "PERSON S REFUND INCOME";
label variable REFIMP98 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP98X "PERSON S ALIMONY INCOME";
label variable ALIIMP98 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP98X "PERSON S CHILD SUPPORT";
label variable CHLIMP98 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP98X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP98 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP98X "PERSON S SSI";
label variable SSIIMP98 "SSI IMPUTATION FLAG";
label variable PUBP98X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP98 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP98X "PERSON S OTHER INCOME";
label variable OTHIMP98 "OTHER INCOME IMPUTAION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/98";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED R3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED R4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED R5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT R3/1 CMJ";
label variable DISVW42X "DISAVOWED HEALTH INS AT R4/2 CMJ";
label variable DISVW53X "DISAVOWED HEALTH INS AT R5/3 CMJ";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable CIND31 "CONDENSED INDUSTRY CODE RD 3/1 CMJ";
label variable CIND42 "CONDENSED INDUSTRY CODE RD 4/2 CMJ";
label variable CIND53 "CONDENSED INDUSTRY CODE RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable COCCP31 "CONDENSED OCCUPATION CODE RD 3/1 CMJ";
label variable COCCP42 "CONDENSED OCCUPATION CODE RD 4/2 CMJ";
label variable COCCP53 "CONDENSED OCCUPATION CODE RD 5/3 CMJ";
label variable BGNWK31 "USUAL START TIME OF RD 3/1 CMJ";
label variable BGNWK42 "USUAL START TIME OF RD 4/2 CMJ";
label variable BGNWK53 "USUAL START TIME OF RD 5/3 CMJ";
label variable ENDWK31 "USUAL END TIME OF RD 3/1 CMJ";
label variable ENDWK42 "USUAL END TIME OF RD 4/2 CMJ";
label variable ENDWK53 "USUAL END TIME OF RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable SHFTWK31 "IRREGULAR WORK SHIFT RD 3/1 CMJ";
label variable SHFTWK42 "IRREGULAR WORK SHIFT RD 4/2 CMJ";
label variable SHFTWK53 "IRREGULAR WORK SHIFT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSURANCE HELD FROM RD 3/1 CMJ";
label variable HELD42X "HEALTH INSURANCE HELD FROM RD 4/2 CMJ";
label variable HELD53X "HEALTH INSURANCE HELD FROM RD 5/3 CMJ";
label variable OFFER31X "HEALTH INSURANCE OFFERED BY RD 3/1 CMJ";
label variable OFFER42X "HEALTH INSURANCE OFFERED BY RD 4/2 CMJ";
label variable OFFER53X "HEALTH INSURANCE OFFERED BY RD 5/3 CMJ";
label variable CHJA98X "COV BY CHAMPUS/CHMPVA/TRICARE JAN98 (ED)";
label variable CHFE98X "COV BY CHAMPUS/CHMPVA/TRICARE FEB98 (ED)";
label variable CHMA98X "COV BY CHAMPUS/CHMPVA/TRICARE MAR98 (ED)";
label variable CHAP98X "COV BY CHAMPUS/CHMPVA/TRICARE APR98 (ED)";
label variable CHMY98X "COV BY CHAMPUS/CHMPVA/TRICARE MAY98 (ED)";
label variable CHJU98X "COV BY CHAMPUS/CHMPVA/TRICARE JUN98 (ED)";
label variable CHJL98X "COV BY CHAMPUS/CHMPVA/TRICARE JUL98 (ED)";
label variable CHAU98X "COV BY CHAMPUS/CHMPVA/TRICARE AUG98 (ED)";
label variable CHSE98X "COV BY CHAMPUS/CHMPVA/TRICARE SEP98 (ED)";
label variable CHOC98X "COV BY CHAMPUS/CHMPVA/TRICARE OCT98 (ED)";
label variable CHNO98X "COV BY CHAMPUS/CHMPVA/TRICARE NOV98 (ED)";
label variable CHDE98X "COV BY CHAMPUS/CHMPVA/TRICARE DEC98 (ED)";
label variable MCRJA98 "COVERED BY MEDICARE IN JAN98";
label variable MCRFE98 "COVERED BY MEDICARE IN FEB98";
label variable MCRMA98 "COVERED BY MEDICARE IN MAR98";
label variable MCRAP98 "COVERED BY MEDICARE IN APR98";
label variable MCRMY98 "COVERED BY MEDICARE IN MAY98";
label variable MCRJU98 "COVERED BY MEDICARE IN JUN98";
label variable MCRJL98 "COVERED BY MEDICARE IN JUL98";
label variable MCRAU98 "COVERED BY MEDICARE IN AUG98";
label variable MCRSE98 "COVERED BY MEDICARE IN SEP98";
label variable MCROC98 "COVERED BY MEDICARE IN OCT98";
label variable MCRNO98 "COVERED BY MEDICARE IN NOV98";
label variable MCRDE98 "COVERED BY MEDICARE IN DEC98";
label variable MCRJA98X "COVERED BY MEDICARE IN JAN98 (ED)";
label variable MCRFE98X "COVERED BY MEDICARE IN FEB98 (ED)";
label variable MCRMA98X "COVERED BY MEDICARE IN MAR98 (ED)";
label variable MCRAP98X "COVERED BY MEDICARE IN APR98 (ED)";
label variable MCRMY98X "COVERED BY MEDICARE IN MAY98 (ED)";
label variable MCRJU98X "COVERED BY MEDICARE IN JUN98 (ED)";
label variable MCRJL98X "COVERED BY MEDICARE IN JUL98 (ED)";
label variable MCRAU98X "COVERED BY MEDICARE IN AUG98 (ED)";
label variable MCRSE98X "COVERED BY MEDICARE IN SEP98 (ED)";
label variable MCROC98X "COVERED BY MEDICARE IN OCT98 (ED)";
label variable MCRNO98X "COVERED BY MEDICARE IN NOV98 (ED)";
label variable MCRDE98X "COVERED BY MEDICARE IN DEC98 (ED)";
label variable MCDJA98 "COVERED BY MEDICAID IN JAN98";
label variable MCDFE98 "COVERED BY MEDICAID IN FEB98";
label variable MCDMA98 "COVERED BY MEDICAID IN MAR98";
label variable MCDAP98 "COVERED BY MEDICAID IN APR98";
label variable MCDMY98 "COVERED BY MEDICAID IN MAY98";
label variable MCDJU98 "COVERED BY MEDICAID IN JUN98";
label variable MCDJL98 "COVERED BY MEDICAID IN JUL98";
label variable MCDAU98 "COVERED BY MEDICAID IN AUG98";
label variable MCDSE98 "COVERED BY MEDICAID IN SEP98";
label variable MCDOC98 "COVERED BY MEDICAID IN OCT98";
label variable MCDNO98 "COVERED BY MEDICAID IN NOV98";
label variable MCDDE98 "COVERED BY MEDICAID IN DEC98";
label variable MCDJA98X "COVERED BY MEDICAID IN JAN98 (ED)";
label variable MCDFE98X "COVERED BY MEDICAID IN FEB98 (ED)";
label variable MCDMA98X "COVERED BY MEDICAID IN MAR98 (ED)";
label variable MCDAP98X "COVERED BY MEDICAID IN APR98 (ED)";
label variable MCDMY98X "COVERED BY MEDICAID IN MAY98 (ED)";
label variable MCDJU98X "COVERED BY MEDICAID IN JUN98 (ED)";
label variable MCDJL98X "COVERED BY MEDICAID IN JUL98 (ED)";
label variable MCDAU98X "COVERED BY MEDICAID IN AUG98 (ED)";
label variable MCDSE98X "COVERED BY MEDICAID IN SEP98 (ED)";
label variable MCDOC98X "COVERED BY MEDICAID IN OCT98 (ED)";
label variable MCDNO98X "COVERED BY MEDICAID IN NOV98 (ED)";
label variable MCDDE98X "COVERED BY MEDICAID IN DEC98 (ED)";
label variable OPAJA98 "COV BY OTHER PUBLIC A INS IN JAN98";
label variable OPAFE98 "COV BY OTHER PUBLIC A INS IN FEB98";
label variable OPAMA98 "COV BY OTHER PUBLIC A INS IN MAR98";
label variable OPAAP98 "COV BY OTHER PUBLIC A INS IN APR98";
label variable OPAMY98 "COV BY OTHER PUBLIC A INS IN MAY98";
label variable OPAJU98 "COV BY OTHER PUBLIC A INS IN JUN98";
label variable OPAJL98 "COV BY OTHER PUBLIC A INS IN JUL98";
label variable OPAAU98 "COV BY OTHER PUBLIC A INS IN AUG98";
label variable OPASE98 "COV BY OTHER PUBLIC A INS IN SEP98";
label variable OPAOC98 "COV BY OTHER PUBLIC A INS IN OCT98";
label variable OPANO98 "COV BY OTHER PUBLIC A INS IN NOV98";
label variable OPADE98 "COV BY OTHER PUBLIC A INS IN DEC98";
label variable OPBJA98 "COV BY OTHER PUBLIC B INS IN JAN98";
label variable OPBFE98 "COV BY OTHER PUBLIC B INS IN FEB98";
label variable OPBMA98 "COV BY OTHER PUBLIC B INS IN MAR98";
label variable OPBAP98 "COV BY OTHER PUBLIC B INS IN APR98";
label variable OPBMY98 "COV BY OTHER PUBLIC B INS IN MAY98";
label variable OPBJU98 "COV BY OTHER PUBLIC B INS IN JUN98";
label variable OPBJL98 "COV BY OTHER PUBLIC B INS IN JUL98";
label variable OPBAU98 "COV BY OTHER PUBLIC B INS IN AUG98";
label variable OPBSE98 "COV BY OTHER PUBLIC B INS IN SEP98";
label variable OPBOC98 "COV BY OTHER PUBLIC B INS IN OCT98";
label variable OPBNO98 "COV BY OTHER PUBLIC B INS IN NOV98";
label variable OPBDE98 "COV BY OTHER PUBLIC B INS IN DEC98";
label variable STAJA98 "COVERED BY OTHER STATE PROG IN JAN98";
label variable STAFE98 "COVERED BY OTHER STATE PROG IN FEB98";
label variable STAMA98 "COVERED BY OTHER STATE PROG IN MAR98";
label variable STAAP98 "COVERED BY OTHER STATE PROG IN APR98";
label variable STAMY98 "COVERED BY OTHER STATE PROG IN MAY98";
label variable STAJU98 "COVERED BY OTHER STATE PROG IN JUN98";
label variable STAJL98 "COVERED BY OTHER STATE PROG IN JUL98";
label variable STAAU98 "COVERED BY OTHER STATE PROG IN AUG98";
label variable STASE98 "COVERED BY OTHER STATE PROG IN SEP98";
label variable STAOC98 "COVERED BY OTHER STATE PROG IN OCT98";
label variable STANO98 "COVERED BY OTHER STATE PROG IN NOV98";
label variable STADE98 "COVERED BY OTHER STATE PROG IN DEC98";
label variable PUBJA98X "COVR BY ANY PUBLIC INS IN JAN98 (ED)";
label variable PUBFE98X "COVR BY ANY PUBLIC INS IN FEB98 (ED)";
label variable PUBMA98X "COVR BY ANY PUBLIC INS IN MAR98 (ED)";
label variable PUBAP98X "COVR BY ANY PUBLIC INS IN APR98 (ED)";
label variable PUBMY98X "COVR BY ANY PUBLIC INS IN MAY98 (ED)";
label variable PUBJU98X "COVR BY ANY PUBLIC INS IN JUN98 (ED)";
label variable PUBJL98X "COVR BY ANY PUBLIC INS IN JUL98 (ED)";
label variable PUBAU98X "COVR BY ANY PUBLIC INS IN AUG98 (ED)";
label variable PUBSE98X "COVR BY ANY PUBLIC INS IN SEP98 (ED)";
label variable PUBOC98X "COVR BY ANY PUBLIC INS IN OCT98 (ED)";
label variable PUBNO98X "COVR BY ANY PUBLIC INS IN NOV98 (ED)";
label variable PUBDE98X "COVR BY ANY PUBLIC INS IN DEC98 (ED)";
label variable PEGJA98 "COVERED BY EMPL UNION INS IN JAN98";
label variable PEGFE98 "COVERED BY EMPL UNION INS IN FEB98";
label variable PEGMA98 "COVERED BY EMPL UNION INS IN MAR98";
label variable PEGAP98 "COVERED BY EMPL UNION INS IN APR98";
label variable PEGMY98 "COVERED BY EMPL UNION INS IN MAY98";
label variable PEGJU98 "COVERED BY EMPL UNION INS IN JUN98";
label variable PEGJL98 "COVERED BY EMPL UNION INS IN JUL98";
label variable PEGAU98 "COVERED BY EMPL UNION INS IN AUG98";
label variable PEGSE98 "COVERED BY EMPL UNION INS IN SEP98";
label variable PEGOC98 "COVERED BY EMPL UNION INS IN OCT98";
label variable PEGNO98 "COVERED BY EMPL UNION INS IN NOV98";
label variable PEGDE98 "COVERED BY EMPL UNION INS IN DEC98";
label variable PDKJA98 "COVR BY PRIV INS (SOURCE UNKNWN) JAN98";
label variable PDKFE98 "COVR BY PRIV INS (SOURCE UNKNWN) FEB98";
label variable PDKMA98 "COVR BY PRIV INS (SOURCE UNKNWN) MAR98";
label variable PDKAP98 "COVR BY PRIV INS (SOURCE UNKNWN) APR98";
label variable PDKMY98 "COVR BY PRIV INS (SOURCE UNKNWN) MAY98";
label variable PDKJU98 "COVR BY PRIV INS (SOURCE UNKNWN) JUN98";
label variable PDKJL98 "COVR BY PRIV INS (SOURCE UNKNWN) JUL98";
label variable PDKAU98 "COVR BY PRIV INS (SOURCE UNKNWN) AUG98";
label variable PDKSE98 "COVR BY PRIV INS (SOURCE UNKNWN) SEP98";
label variable PDKOC98 "COVR BY PRIV INS (SOURCE UNKNWN) OCT98";
label variable PDKNO98 "COVR BY PRIV INS (SOURCE UNKNWN) NOV98";
label variable PDKDE98 "COVR BY PRIV INS (SOURCE UNKNWN) DEC98";
label variable PNGJA98 "COVERED BY NONGROUP INS IN JAN98";
label variable PNGFE98 "COVERED BY NONGROUP INS IN FEB98";
label variable PNGMA98 "COVERED BY NONGROUP INS IN MAR98";
label variable PNGAP98 "COVERED BY NONGROUP INS IN APR98";
label variable PNGMY98 "COVERED BY NONGROUP INS IN MAY98";
label variable PNGJU98 "COVERED BY NONGROUP INS IN JUN98";
label variable PNGJL98 "COVERED BY NONGROUP INS IN JUL98";
label variable PNGAU98 "COVERED BY NONGROUP INS IN AUG98";
label variable PNGSE98 "COVERED BY NONGROUP INS IN SEP98";
label variable PNGOC98 "COVERED BY NONGROUP INS IN OCT98";
label variable PNGNO98 "COVERED BY NONGROUP INS IN NOV98";
label variable PNGDE98 "COVERED BY NONGROUP INS IN DEC98";
label variable POGJA98 "COVERED BY OTHER GROUP INS IN JAN98";
label variable POGFE98 "COVERED BY OTHER GROUP INS IN FEB98";
label variable POGMA98 "COVERED BY OTHER GROUP INS IN MAR98";
label variable POGAP98 "COVERED BY OTHER GROUP INS IN APR98";
label variable POGMY98 "COVERED BY OTHER GROUP INS IN MAY98";
label variable POGJU98 "COVERED BY OTHER GROUP INS IN JUN98";
label variable POGJL98 "COVERED BY OTHER GROUP INS IN JUL98";
label variable POGAU98 "COVERED BY OTHER GROUP INS IN AUG98";
label variable POGSE98 "COVERED BY OTHER GROUP INS IN SEP98";
label variable POGOC98 "COVERED BY OTHER GROUP INS IN OCT98";
label variable POGNO98 "COVERED BY OTHER GROUP INS IN NOV98";
label variable POGDE98 "COVERED BY OTHER GROUP INS IN DEC98";
label variable PRSJA98 "COVERED BY SELF-EMP-1 INS IN JAN98";
label variable PRSFE98 "COVERED BY SELF-EMP-1 INS IN FEB98";
label variable PRSMA98 "COVERED BY SELF-EMP-1 INS IN MAR98";
label variable PRSAP98 "COVERED BY SELF-EMP-1 INS IN APR98";
label variable PRSMY98 "COVERED BY SELF-EMP-1 INS IN MAY98";
label variable PRSJU98 "COVERED BY SELF-EMP-1 INS IN JUN98";
label variable PRSJL98 "COVERED BY SELF-EMP-1 INS IN JUL98";
label variable PRSAU98 "COVERED BY SELF-EMP-1 INS IN AUG98";
label variable PRSSE98 "COVERED BY SELF-EMP-1 INS IN SEP98";
label variable PRSOC98 "COVERED BY SELF-EMP-1 INS IN OCT98";
label variable PRSNO98 "COVERED BY SELF-EMP-1 INS IN NOV98";
label variable PRSDE98 "COVERED BY SELF-EMP-1 INS IN DEC98";
label variable POUJA98 "COVERED BY HOLDER OUTSIDE OF RU IN JAN98";
label variable POUFE98 "COVERED BY HOLDER OUTSIDE OF RU IN FEB98";
label variable POUMA98 "COVERED BY HOLDER OUTSIDE OF RU IN MAR98";
label variable POUAP98 "COVERED BY HOLDER OUTSIDE OF RU IN APR98";
label variable POUMY98 "COVERED BY HOLDER OUTSIDE OF RU IN MAY98";
label variable POUJU98 "COVERED BY HOLDER OUTSIDE OF RU IN JUN98";
label variable POUJL98 "COVERED BY HOLDER OUTSIDE OF RU IN JUL98";
label variable POUAU98 "COVERED BY HOLDER OUTSIDE OF RU IN AUG98";
label variable POUSE98 "COVERED BY HOLDER OUTSIDE OF RU IN SEP98";
label variable POUOC98 "COVERED BY HOLDER OUTSIDE OF RU IN OCT98";
label variable POUNO98 "COVERED BY HOLDER OUTSIDE OF RU IN NOV98";
label variable POUDE98 "COVERED BY HOLDER OUTSIDE OF RU IN DEC98";
label variable PRIJA98 "COVERED BY PRIVATE INS IN JAN98";
label variable PRIFE98 "COVERED BY PRIVATE INS IN FEB98";
label variable PRIMA98 "COVERED BY PRIVATE INS IN MAR98";
label variable PRIAP98 "COVERED BY PRIVATE INS IN APR98";
label variable PRIMY98 "COVERED BY PRIVATE INS IN MAY98";
label variable PRIJU98 "COVERED BY PRIVATE INS IN JUN98";
label variable PRIJL98 "COVERED BY PRIVATE INS IN JUL98";
label variable PRIAU98 "COVERED BY PRIVATE INS IN AUG98";
label variable PRISE98 "COVERED BY PRIVATE INS IN SEP98";
label variable PRIOC98 "COVERED BY PRIVATE INS IN OCT98";
label variable PRINO98 "COVERED BY PRIVATE INS IN NOV98";
label variable PRIDE98 "COVERED BY PRIVATE INS IN DEC98";
label variable HPEJA98 "HOLDER OF EMPL UNION INS IN JAN98";
label variable HPEFE98 "HOLDER OF EMPL UNION INS IN FEB98";
label variable HPEMA98 "HOLDER OF EMPL UNION INS IN MAR98";
label variable HPEAP98 "HOLDER OF EMPL UNION INS IN APR98";
label variable HPEMY98 "HOLDER OF EMPL UNION INS IN MAY98";
label variable HPEJU98 "HOLDER OF EMPL UNION INS IN JUN98";
label variable HPEJL98 "HOLDER OF EMPL UNION INS IN JUL98";
label variable HPEAU98 "HOLDER OF EMPL UNION INS IN AUG98";
label variable HPESE98 "HOLDER OF EMPL UNION INS IN SEP98";
label variable HPEOC98 "HOLDER OF EMPL UNION INS IN OCT98";
label variable HPENO98 "HOLDER OF EMPL UNION INS IN NOV98";
label variable HPEDE98 "HOLDER OF EMPL UNION INS IN DEC98";
label variable HPDJA98 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN98";
label variable HPDFE98 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB98";
label variable HPDMA98 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR98";
label variable HPDAP98 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR98";
label variable HPDMY98 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY98";
label variable HPDJU98 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN98";
label variable HPDJL98 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL98";
label variable HPDAU98 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG98";
label variable HPDSE98 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP98";
label variable HPDOC98 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT98";
label variable HPDNO98 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV98";
label variable HPDDE98 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC98";
label variable HPNJA98 "HOLDER OF NONGROUP INS IN JAN98";
label variable HPNFE98 "HOLDER OF NONGROUP INS IN FEB98";
label variable HPNMA98 "HOLDER OF NONGROUP INS IN MAR98";
label variable HPNAP98 "HOLDER OF NONGROUP INS IN APR98";
label variable HPNMY98 "HOLDER OF NONGROUP INS IN MAY98";
label variable HPNJU98 "HOLDER OF NONGROUP INS IN JUN98";
label variable HPNJL98 "HOLDER OF NONGROUP INS IN JUL98";
label variable HPNAU98 "HOLDER OF NONGROUP INS IN AUG98";
label variable HPNSE98 "HOLDER OF NONGROUP INS IN SEP98";
label variable HPNOC98 "HOLDER OF NONGROUP INS IN OCT98";
label variable HPNNO98 "HOLDER OF NONGROUP INS IN NOV98";
label variable HPNDE98 "HOLDER OF NONGROUP INS IN DEC98";
label variable HPOJA98 "HOLDER OF OTHER GROUP INS IN JAN98";
label variable HPOFE98 "HOLDER OF OTHER GROUP INS IN FEB98";
label variable HPOMA98 "HOLDER OF OTHER GROUP INS IN MAR98";
label variable HPOAP98 "HOLDER OF OTHER GROUP INS IN APR98";
label variable HPOMY98 "HOLDER OF OTHER GROUP INS IN MAY98";
label variable HPOJU98 "HOLDER OF OTHER GROUP INS IN JUN98";
label variable HPOJL98 "HOLDER OF OTHER GROUP INS IN JUL98";
label variable HPOAU98 "HOLDER OF OTHER GROUP INS IN AUG98";
label variable HPOSE98 "HOLDER OF OTHER GROUP INS IN SEP98";
label variable HPOOC98 "HOLDER OF OTHER GROUP INS IN OCT98";
label variable HPONO98 "HOLDER OF OTHER GROUP INS IN NOV98";
label variable HPODE98 "HOLDER OF OTHER GROUP INS IN DEC98";
label variable HPSJA98 "HOLDER OF SELF-EMP-1 INS IN JAN98";
label variable HPSFE98 "HOLDER OF SELF-EMP-1 INS IN FEB98";
label variable HPSMA98 "HOLDER OF SELF-EMP-1 INS IN MAR98";
label variable HPSAP98 "HOLDER OF SELF-EMP-1 INS IN APR98";
label variable HPSMY98 "HOLDER OF SELF-EMP-1 INS IN MAY98";
label variable HPSJU98 "HOLDER OF SELF-EMP-1 INS IN JUN98";
label variable HPSJL98 "HOLDER OF SELF-EMP-1 INS IN JUL98";
label variable HPSAU98 "HOLDER OF SELF-EMP-1 INS IN AUG98";
label variable HPSSE98 "HOLDER OF SELF-EMP-1 INS IN SEP98";
label variable HPSOC98 "HOLDER OF SELF-EMP-1 INS IN OCT98";
label variable HPSNO98 "HOLDER OF SELF-EMP-1 INS IN NOV98";
label variable HPSDE98 "HOLDER OF SELF-EMP-1 INS IN DEC98";
label variable HPRJA98 "HOLDER OF PRIVATE INSURANCE IN JAN98";
label variable HPRFE98 "HOLDER OF PRIVATE INSURANCE IN FEB98";
label variable HPRMA98 "HOLDER OF PRIVATE INSURANCE IN MAR98";
label variable HPRAP98 "HOLDER OF PRIVATE INSURANCE IN APR98";
label variable HPRMY98 "HOLDER OF PRIVATE INSURANCE IN MAY98";
label variable HPRJU98 "HOLDER OF PRIVATE INSURANCE IN JUN98";
label variable HPRJL98 "HOLDER OF PRIVATE INSURANCE IN JUL98";
label variable HPRAU98 "HOLDER OF PRIVATE INSURANCE IN AUG98";
label variable HPRSE98 "HOLDER OF PRIVATE INSURANCE IN SEP98";
label variable HPROC98 "HOLDER OF PRIVATE INSURANCE IN OCT98";
label variable HPRNO98 "HOLDER OF PRIVATE INSURANCE IN NOV98";
label variable HPRDE98 "HOLDER OF PRIVATE INSURANCE IN DEC98";
label variable INSJA98X "COVR BY HOSP/MED INS IN JAN98 (ED)";
label variable INSFE98X "COVR BY HOSP/MED INS IN FEB98 (ED)";
label variable INSMA98X "COVR BY HOSP/MED INS IN MAR98 (ED)";
label variable INSAP98X "COVR BY HOSP/MED INS IN APR98 (ED)";
label variable INSMY98X "COVR BY HOSP/MED INS IN MAY98 (ED)";
label variable INSJU98X "COVR BY HOSP/MED INS IN JUN98 (ED)";
label variable INSJL98X "COVR BY HOSP/MED INS IN JUL98 (ED)";
label variable INSAU98X "COVR BY HOSP/MED INS IN AUG98 (ED)";
label variable INSSE98X "COVR BY HOSP/MED INS IN SEP98 (ED)";
label variable INSOC98X "COVR BY HOSP/MED INS IN OCT98 (ED)";
label variable INSNO98X "COVR BY HOSP/MED INS IN NOV98 (ED)";
label variable INSDE98X "COVR BY HOSP/MED INS IN DEC98 (ED)";
label variable PRVEV98 "EVER HAVE PRIVATE INSURANCE DURING 98";
label variable CHPEV98 "EVER HAVE CHAMPUS/CHAMPVA DURING 98";
label variable MCREV98 "EVER HAVE MEDICARE DURING 98";
label variable MCDEV98 "EVER HAVE MEDICAID DURING 98";
label variable OPAEV98 "EVER HAVE OTHER PUBLIC A INS DURING 98";
label variable OPBEV98 "EVER HAVE OTHER PUBLIC B INS DURING 98";
label variable UNINS98 "UNINSURED ALL OF 98";
label variable INSCOV98 "HEALTH INSURANCE COVERAGE INDICATOR 98";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable RTPROX31 "SELF/PROXY RATING OF HEALTH - RD 3/1";
label variable RTPROX42 "SELF/PROXY RATING OF HEALTH - RD 4/2";
label variable RTPROX53 "SELF/PROXY RATING OF HEALTH - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable MNPROX31 "SELF/PROXY RATING OF MENTAL HEALTH-R3/1";
label variable MNPROX42 "SELF/PROXY RATING OF MENTAL HEALTH-R4/2";
label variable MNPROX53 "SELF/PROXY RATING OF MENTAL HEALTH-R5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS RD - 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM98 "ANY LIMITATION IN P2R3,4,5/P3R1,2,3";
label variable LIMACT42 "LIMITED IN ANY ACTIVITIES (<5 YR)-RD 4/2";
label variable PLYLIM42 "LIMITED IN PLAY ACTIVITY (<5 YRS)-RD 4/2";
label variable CANTPL42 "CAN T PARTICIPATE USUAL PLAY(<5 YR)-R4/2";
label variable SPCPRO42 "IN SPECIAL PROGRAM (<5 YRS) - RD 4/2";
label variable DPTSHT42 "IMMUNIZATION FOR DPT (<7 YRS) - RD 4/2";
label variable NUMDPT42 "ONE OR SEVERAL DPT SHOTS (<7 YRS)-RD 4/2";
label variable POLSHT42 "IMMUNIZATION FOR POLIO (<7 YRS)-RD 4/2";
label variable NUMPOL42 "ONE OR SEVERAL POLIO SHOTS (<7 YR)-RD4/2";
label variable MMRSHT42 "IMMUNIZATION MEASLES/MUMPS/RUBELLA-R4/2";
label variable HEPSHT42 "IMMUNIZATION FOR HEPATITIS (<7 YR)-RD4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-RD4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-RD4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-RD4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-RD 4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - RD 4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PROBLEM GETTING ALONG W/SIB (5-17)-RD4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-RD 4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17) - RD 4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-RD 4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-RD 4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-RD 4/2";
label variable SPCSCH42 "NEED SPECIAL SCHOOL PROGRAM (5-17)-RD4/2";
label variable SPECED42 "IN SPECIAL EDUCATION (5-17) - RD 4/2";
label variable SPCHTH42 "RECEIVED SPEECH THERAPY (5-17) - RD 4/2";
label variable PSYCNS42 "PSYCHOLOGICAL COUNSELING (5-17) - RD 4/2";
label variable OCUPTH42 "RECEIVED OCCUPATIONAL THRPY (5-17)-R4/2";
label variable VOCSVC42 "RECEIVED VOCATIONAL SERVICES (5-17)-R4/2";
label variable TUTOR42 "RECEIVED TUTORING (5-17) - RD 4/2";
label variable READIN42 "USED READER OR INTERPRETER (5-17)-RD 4/2";
label variable PHYTHR42 "RECEIVED PHYSICAL THERAPY (5-17)-RD 4/2";
label variable LIFSKL42 "RECEIVED LIFE SKILLS TRAINING(5-17)-R4/2";
label variable FAMCNS42 "RECEIVED FAMILY COUNSELING (5-17)-RD 4/2";
label variable RECTHR42 "RECEIVED RECREATIONAL THRPY (5-17)-R4/2";
label variable OTHSVC42 "RECEIVED OTH SCHOOL SERVICE (5-17)-RD4/2";
label variable CANTSC42 "LMTED/UNABLE TO GO TO SCHOOL (5-17)-R4/2";
label variable LMOACT42 "LMTED IN NON-SCHOOL ACTIVITY (5-17)-R4/2";
label variable HLTHY42 "CHILD RESISTS ILLNESS WELL (0-17)-RD 4/2";
label variable NTHLTH42 "LESS HLTHY THAN SAME AGE KIDS(0-17)-R4/2";
label variable GETSIC42 "CHILD CATCHES WHAT S AROUND (0-17)-R4/2";
label variable HGTFT42 "CHILD S HEIGHT - FEET (0-17) - RD 4/2";
label variable HGTIN42 "CHILD S HEIGHT - INCHES (0-17) - RD 4/2";
label variable WGTLB42 "CHILD S WEIGHT - POUNDS (0-17) - RD 4/2";
label variable WGTOZ42 "CHILD S WEIGHT - OUNCES (0-17) - RD 4/2";
label variable CHLIM42 "CHILD HAS ANY LIMITATION (0-17) - RD 4/2";
label variable DENTCK98 "DENTAL CHECKUP FREQUENCY  98";
label variable BLDPCK98 "TIME SINCE BLOOD PRESSURE CHECK  98";
label variable CHOLCK98 "TIME SINCE CHOLESTEROL CHECK  98";
label variable PHYSCL98 "TIME SINCE COMPLETE PHYSICAL  98";
label variable FLUSHT98 "TIME SINCE FLU SHOT  98";
label variable WRDENT98 "PERSON WEARS DENTURES  98";
label variable LOSTEE98 "PERSON LOST ALL ADULT TEETH  98";
label variable PROSEX98 "TIME SINCE PROSTATE EXAM  98";
label variable PAPSMR98 "TIME SINCE PAP SMEAR  98";
label variable BRSTEX98 "TIME SINCE BREAST EXAM  98";
label variable MAMGRM98 "TIME SINCE MAMMOGRAM  98";
label variable ALTCAR98 "ANY ALTERNATIVE CARE USE  98";
label variable ALTCVS98 "NUM OF VISITS TO ALTERNATIVE CARE  98";
label variable ALTCVE98 "ESTIMATED RANGE OF ALT TX VISITS  98";
label variable ALTCRE98 "ESTIMATE TOTAL AMT SPENT FOR ALT CARE 98";
label variable ALTCRX98 "RANGE OF AMOUNT SPENT FOR ALT CARE  98";
label variable INSALT98 "DID INSURANCE PAY FOR ALT CARE  98";
label variable PERINS98 "EST % ALT CARE PAID BY INSURANCE  98";
label variable PRALTX98 "TOTAL SPENT ON ALT CARE REMEDIES  98";
label variable PRALTE98 "RANGE SPENT ON ALT CARE REMEDIES  98";
label variable ACUPNC98 "PERSON RECEIVED ACUPUNCTURE  98";
label variable NUTRIT98 "PERSON RECEIVED NUTRITIONAL ADVICE  98";
label variable MASAGE98 "PERSON RECEIVED MASSAGE THERAPY  98";
label variable HERBAL98 "PERSON PURCHASED HERBAL REMEDIES  98";
label variable BIOFDB98 "PERSON RECEIVED BIOFEEDBACK  98";
label variable MEDITA98 "PERSON RECEIVED MEDITATION TRAINING  98";
label variable HOMEO98 "PERSON RECEIVED HOMEOPATHIC THERAPY  98";
label variable SPIRTL98 "PERSON RECEIVED SPIRITUAL HEALING  98";
label variable HYPNO98 "PERSON RECEIVED HYPNOSIS  98";
label variable TRADIT98 "PERSON RECEIVED TRADITIONAL MEDICINE  98";
label variable ALTOTH98 "PERSON RECEIVED OTHER ALTERNATIVE TX  98";
label variable MASTHE98 "PERSON SAW MASSAGE THERAPIST  98";
label variable ACPTHE98 "PERSON SAW ACUPUNCTURIST  98";
label variable MDTRT98 "PER SAW PHYSICIAN FOR ALTERNATIVE TX  98";
label variable NURTRT98 "PERSON SAW NURSE FOR ALTERNATIVE TX  98";
label variable HOMEMD98 "PERS SAW HOMEOPATHIC/NATUROPATHIC DOC 98";
label variable CHIRO98 "PERSON SAW CHIROPRACTOR  98";
label variable CLERGY98 "PERSON SAW CLERGY OR SPIRITUALIST  98";
label variable HERBTR98 "PERSON SAW HERBALIST  98";
label variable OTHALT98 "PERS SAW OTH PRACTITIONER FOR ALT TX  98";
label variable ALTCSP98 "USED ALT CARE FOR SPECIFIC HLTH PROB  98";
label variable DSCALT98 "DISCUSSED ALT CARE WITH REGULAR MD  98";
label variable REFRMD98 "REFERRED BY PHYSICIAN FOR ALT TX  98";
label variable WHRCAR98 "WHERE WAS CHILD CARE PROVIDED  98";
label variable WHOCAR98 "WHO PROVIDED CHILD CARE  98";
label variable DAYCAR98 "CHILD CARE ARRANGEMENTS REQUIRED  98";
label variable TOTTCH98 "TOTAL HEALTH CARE CHARGES 98, EXCL RX";
label variable TOTEXP98 "TOTAL HEALTH CARE EXP 98";
label variable TOTSLF98 "TOTAL AMT PAID BY SELF/FAMILY 98";
label variable TOTMCR98 "TOTAL AMT PAID BY MEDICARE 98";
label variable TOTMCD98 "TOTAL AMT PAID BY MEDICAID 98";
label variable TOTPRV98 "TOTAL AMT PAID BY PRIVATE INS 98";
label variable TOTVA98 "TOTL AMT PAID BY VA 98";
label variable TOTCHM98 "TOTL AMT PAID BY CHAMPUS/CHAMPVA 98";
label variable TOTOFD98 "TOTL AMT PAID BY OTHER FEDERAL 98";
label variable TOTSTL98 "TOTL AMT PAID BY OTH ST/LOCAL 98";
label variable TOTWCP98 "TOTL AMT PAID BY WORKERS COMP 98";
label variable TOTOPR98 "TOTL AMT PAID BY OTHER PRIVATE 98";
label variable TOTOPU98 "TOTL AMT PAID BY OTHER PUBLIC 98";
label variable TOTOSR98 "TOTL AMT PAID BY OTHER SOURCES 98";
label variable OBTOTV98 "# OFFICE-BASED PROVIDER VISITS 98";
label variable OBVTCH98 "OFFICE-BASED PROVIDER VISIT CHARGES 98";
label variable OBVEXP98 "TOTAL OFFICE-BASED EXP 98";
label variable OBVSLF98 "ALL OFFICE VISITS -SELF/FAMILY AMT 98";
label variable OBVMCR98 "ALL OFFICE VISITS -MEDICARE AMT 98";
label variable OBVMCD98 "ALL OFFICE VISITS -MEDICAID AMT 98";
label variable OBVPRV98 "ALL OFFICE VISITS -PRIVATE INS AMT 98";
label variable OBVVA98 "ALL OFFICE VISITS-VA AMT 98";
label variable OBVCHM98 "ALL OFFICE VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable OBVOFD98 "ALL OFFICE VISITS-OTHER FEDERAL AMT 98";
label variable OBVSTL98 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 98";
label variable OBVWCP98 "ALL OFFICE VISITS -WORKERS COMP AMT 98";
label variable OBVOPR98 "ALL OFFICE VISITS - OTH PRIVATE AMT 98";
label variable OBVOPU98 "ALL OFFICE VISITS - OTH PUBLIC AMT 98";
label variable OBVOSR98 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBDRV98 "# OFFICE-BASED PHYSICIAN VISITS 98";
label variable OBDTCH98 "OFFICE-BASED PHYSICIAN VISIT CHARGES 98";
label variable OBDEXP98 "TOTAL OFF-BASED DR EXP 98";
label variable OBDSLF98 "DR OFFICE VISITS -SELF/FAMILY AMT 98";
label variable OBDMCR98 "DR OFFICE VISITS -MEDICARE AMT 98";
label variable OBDMCD98 "DR OFFICE VISITS -MEDICAID AMT 98";
label variable OBDPRV98 "DR OFFICE VISITS -PRIVATE INS AMT 98";
label variable OBDVA98 "DR OFFICE VISITS -VA AMT 98";
label variable OBDCHM98 "DR OFFICE VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable OBDOFD98 "DR OFFICE VISITS -OTHER FEDERAL AMT 98";
label variable OBDSTL98 "DR OFFICE VISITS -OTH ST/LOCAL AMT 98";
label variable OBDWCP98 "DR OFFICE VISITS -WORKERS COMP AMT 98";
label variable OBDOPR98 "DR OFFICE VISITS - OTH PRIVATE AMT 98";
label variable OBDOPU98 "DR OFFICE VISITS - OTH PUBLIC AMT 98";
label variable OBDOSR98 "DR OFF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBOTHV98 "# OFFICE-BASED NON-PHYSICAN VISITS 98";
label variable OBOTCH98 "OFFICE-BASED NON-DR VISIT CHARGES 98";
label variable OBOEXP98 "TOTAL OFF-BASED NON-DR EXP 98";
label variable OBOSLF98 "NON-DR OFF VISTS -SELF/FAMILY AMT 98";
label variable OBOMCR98 "NON-DR OFF VISTS -MEDICARE AMT 98";
label variable OBOMCD98 "NON-DR OFF VISTS -MEDICAID AMT 98";
label variable OBOPRV98 "NON-DR OFF VISTS -PRIVATE INS AMT 98";
label variable OBOVA98 "NON-DR OFF VISTS -VA AMT 98";
label variable OBOCHM98 "NON-DR OFF VISTS-CHAMPUS/CHAMPVA AMT 98";
label variable OBOOFD98 "NON-DR OFF VISTS -OTHER FEDERAL AMT 98";
label variable OBOSTL98 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 98";
label variable OBOWCP98 "NON-DR OFF VISTS -WORKERS COMP AMT 98";
label variable OBOOPR98 "NON-DR OFF VISTS - OTH PRIVATE AMT 98";
label variable OBOOPU98 "NON-DR OFF VISTS - OTH PUBLIC AMT 98";
label variable OBOOSR98 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBCHIR98 "# OFFICE-BASED CHIROPRACTOR VISITS 98";
label variable OBCTCH98 "OFFICE-BASED CHIRO VISIT CHARGES 98";
label variable OBCEXP98 "TOTAL OFF-BASED CHIRO EXP 98";
label variable OBCSLF98 "CHIRO OFF VISITS -SELF/FAMILY AMT 98";
label variable OBCMCR98 "CHIRO OFF VISITS -MEDICARE AMT 98";
label variable OBCMCD98 "CHIRO OFF VISITS -MEDICAID AMT 98";
label variable OBCPRV98 "CHIRO OFF VISITS -PRIVATE INS AMT 98";
label variable OBCVA98 "CHIRO OFF VISITS -VA AMT 98";
label variable OBCCHM98 "CHIRO OFF VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable OBCOFD98 "CHIRO OFF VISITS -OTHER FEDERAL AMT 98";
label variable OBCSTL98 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 98";
label variable OBCWCP98 "CHIRO OFF VISITS -WORKERS COMP AMT 98";
label variable OBCOPR98 "CHIRO OFF VISTS - OTHR PRIVATE AMT 98";
label variable OBCOPU98 "CHIRO OFF VISTS - OTHR PUBLIC AMT 98";
label variable OBCOSR98 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 98";
label variable OBNURS98 "# OFF-BASED NURSE/PRACTITIONER VISITS 98";
label variable OBNTCH98 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 98";
label variable OBNEXP98 "TOTAL OFF-BASED NURSE/PRAC 98";
label variable OBNSLF98 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 98";
label variable OBNMCR98 "NURSE/PRAC OFF VISITS -MEDICARE AMT 98";
label variable OBNMCD98 "NURSE/PRAC OFF VSTS -MEDICAID AMT 98";
label variable OBNPRV98 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 98";
label variable OBNVA98 "NURSE/PRAC OFF VSTS-VA AMT 98";
label variable OBNCHM98 "NURSE/PRAC OFF VSTS-CHMPUS/CHMPVA AMT 98";
label variable OBNOFD98 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 98";
label variable OBNSTL98 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 98";
label variable OBNWCP98 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 98";
label variable OBNOPR98 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 98";
label variable OBNOPU98 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 98";
label variable OBNOSR98 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBOPTO98 "# OFF-BASED OPTOMETRIST VISITS 98";
label variable OBETCH98 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 98";
label variable OBEEXP98 "TOTAL OFF-BASED OPOTMETRIST EXP 98";
label variable OBESLF98 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 98";
label variable OBEMCR98 "OPTOMETRIST OFF VSTS -MEDICARE AMT 98";
label variable OBEMCD98 "OPTOMETRIST OFF VSTS -MEDICAID AMT 98";
label variable OBEPRV98 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 98";
label variable OBEVA98 "OPTOMETRIST OFF VSTS -VA AMT 98";
label variable OBECHM98 "OPTOMETRIST OFF VSTS-CHMPUS/CHPVA AMT 98";
label variable OBEOFD98 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 98";
label variable OBESTL98 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 98";
label variable OBEWCP98 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 98";
label variable OBEOPR98 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 98";
label variable OBEOPU98 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 98";
label variable OBEOSR98 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBASST98 "# OFF-BASED PHYSICIAN ASSIST VISITS 98";
label variable OBATCH98 "OFFICE-BASED PHYS ASST VISIT CHARGES 98";
label variable OBAEXP98 "TOTAL OFF-BASED PHYS ASS T EXP 98";
label variable OBASLF98 "PHYS ASS T OFF VSTS-SELF/FAMILY AMT 98";
label variable OBAMCR98 "PHYS ASS T OFF VSTS-MEDICARE AMT 98";
label variable OBAMCD98 "PHYS ASS T OFF VSTS-MEDICAID AMT 98";
label variable OBAPRV98 "PHYS ASS T OFF VSTS-PRIVATE INS AMT 98";
label variable OBAVA98 "PHYS ASS T OFF VSTS-VA AMT 98";
label variable OBACHM98 "PHYS ASS T OFF VSTS-CHMPUS/CHMPVA AMT 98";
label variable OBAOFD98 "PHYS ASS T OFF VSTS -OTHER FED AMT 98";
label variable OBASTL98 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 98";
label variable OBAWCP98 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 98";
label variable OBAOPR98 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 98";
label variable OBAOPU98 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 98";
label variable OBAOSR98 "P A OFF VSTS - OTH UNCLASS SRCE AMT 98";
label variable OBTHER98 "# OFF-BASED PT/OT VISITS 98";
label variable OBTTCH98 "OFFICE-BASED PT/OC VISIT CHARGES 98";
label variable OBTEXP98 "TOT OFF-BASED PT EXP 98";
label variable OBTSLF98 "PT/OT OFF VISITS-SELF/FAMILY AMT 98";
label variable OBTMCR98 "PT/OT OFF VISITS-MEDICARE AMT 98";
label variable OBTMCD98 "PT/OT OFF VISITS-MEDICAID AMT 98";
label variable OBTPRV98 "PT/OT OFF VISITS-PRIVATE INS AMT 98";
label variable OBTVA98 "PT/OT OFF VISITS-VA AMT 98";
label variable OBTCHM98 "PT/OT OFF VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable OBTOFD98 "PT/OT OFF VISITS -OTHER FED AMT 98";
label variable OBTSTL98 "PT/OT OFF VISITS-OTH ST/LOCL AMT 98";
label variable OBTWCP98 "PT/OT OFF VISITS-WORKERS COMP AMT 98";
label variable OBTOPR98 "PT/OT OFF VISITS - OTH PRIVATE AMT 98";
label variable OBTOPU98 "PT/OT OFF VISITS - OTH PUBLIC AMT 98";
label variable OBTOSR98 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 98";
label variable OPTOTV98 "# OUTPATIENT DEPT PROVIDER VISITS 98";
label variable OPFTCH98 "OPD PROVIDER VISIT CHARGES - FAC 98";
label variable OPFEXP98 "TOTAL OUTPATIENT FACILITY EXP 98";
label variable OPFSLF98 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 98";
label variable OPFMCR98 "ALL OPD VISITS-MEDICARE AMT-FAC 98";
label variable OPFMCD98 "ALL OPD VISITS-MEDICAID AMT-FAC 98";
label variable OPFPRV98 "ALL OPD VISITS-PRIV INS AMT-FAC 98";
label variable OPFVA98 "ALL OPD VISITS-VA AMT-FAC 98";
label variable OPFCHM98 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-FAC 98";
label variable OPFOFD98 "ALL OPD VISITS-OTHER FED AMT-FAC 98";
label variable OPFSTL98 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 98";
label variable OPFWCP98 "ALL OPD VISITS-WORKERS COMP AMT-FAC 98";
label variable OPFOPR98 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 98";
label variable OPFOPU98 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 98";
label variable OPFOSR98 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 98";
label variable OPDEXP98 "TOTAL OUTPATIENT PROVIDER EXP 98";
label variable OPDTCH98 "OPD PROVIDER VISIT CHARGES - DR 98";
label variable OPDSLF98 "ALL OPD VISITS-SELF/FAMILY AMT-DR 98";
label variable OPDMCR98 "ALL OPD VISITS-MEDICARE AMT -DR 98";
label variable OPDMCD98 "ALL OPD VISITS-MEDICAID AMT -DR 98";
label variable OPDPRV98 "ALL OPD VISITS-PRIV INS AMT-DR 98";
label variable OPDVA98 "ALL OPD VISITS-VA AMT-DR 98";
label variable OPDCHM98 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-DR 98";
label variable OPDOFD98 "ALL OPD VISITS-OTHER FED AMT-DR 98";
label variable OPDSTL98 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 98";
label variable OPDWCP98 "ALL OPD VISITS-WORKERS COMP AMT-DR 98";
label variable OPDOPR98 "ALL OPD VISITS - OTH PRIVATE AMT-DR 98";
label variable OPDOPU98 "ALL OPD VISITS-OTH PUBLIC AMT-DR 98";
label variable OPDOSR98 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 98";
label variable OPDRV98 "# OUTPATIENT DEPT PHYSICIAN VISITS 98";
label variable OPVTCH98 "OPD PHYSICIAN VISIT CHARGES - FAC 98";
label variable OPVEXP98 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 98";
label variable OPVSLF98 "OPD DR VISITS-SELF/FAMILY AMT-FAC 98";
label variable OPVMCR98 "OPD DR VISITS-MEDICARE AMT-FAC 98";
label variable OPVMCD98 "OPD DR VISITS-MEDICAID AMT-FAC 98";
label variable OPVPRV98 "OPD DR VISITS-PRIV INS AMT-FAC 98";
label variable OPVVA98 "OPD DR VISITS-VA AMT-FAC 98";
label variable OPVCHM98 "OPD DR VISITS-CHPUS/CHPVA AMT-FAC 98";
label variable OPVOFD98 "OPD DR VISITS-OTHER FED AMT-FAC 98";
label variable OPVSTL98 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 98";
label variable OPVWCP98 "OPD DR VISITS-WORKERS COMP AMT-FAC 98";
label variable OPVOPR98 "OPD DR VISITS - OTH PRIVATE AMT-FAC 98";
label variable OPVOPU98 "OPD DR VISITS-OTH PUBLIC AMT-FAC 98";
label variable OPVOSR98 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 98";
label variable OPSEXP98 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 98";
label variable OPSTCH98 "OPD PHYSICIAN VISIT CHARGES - DR 98";
label variable OPSSLF98 "OPD DR VISITS-SELF/FAMILY AMT-DR 98";
label variable OPSMCR98 "OPD DR VISITS-MEDICARE AMT-DR 98";
label variable OPSMCD98 "OPD DR VISITS-MEDICAID AMT-DR 98";
label variable OPSPRV98 "OPD DR VISITS-PRIV INS AMT-DR 98";
label variable OPSVA98 "OPD DR VISITS-VA AMT-DR 98";
label variable OPSCHM98 "OPD DR VISITS-CHMPUS/CHMPVA AMT-DR 98";
label variable OPSOFD98 "OPD DR VISITS-OTHER FED AMT-DR 98";
label variable OPSSTL98 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 98";
label variable OPSWCP98 "OPD DR VISITS-WORKERS COMP AMT-DR 98";
label variable OPSOPR98 "OPD DR VISITS - OTH PRIVATE AMT-DR 98";
label variable OPSOPU98 "OPD DR VISITS-OTH PUBLIC AMT-DR 98";
label variable OPSOSR98 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 98";
label variable OPOTHV98 "# OUTPATIENT DEPT NON-DR VISITS 98";
label variable OPOTCH98 "OPD NON-PHYS VISIT CHARGES - FAC 98";
label variable OPOEXP98 "TOTAL OUTPATIENT NON-DR - FAC EXP 98";
label variable OPOSLF98 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 98";
label variable OPOMCR98 "OPD NON-DR VISITS-MEDICARE AMT-FAC 98";
label variable OPOMCD98 "OPD NON-DR VISITS-MEDICAID AMT-FAC 98";
label variable OPOPRV98 "OPD NON-DR VISITS-PRIV INS AMT-FAC 98";
label variable OPOVA98 "OPD NON-DR VISITS-VA AMT-FAC 98";
label variable OPOCHM98 "OPD NON-DR VISITS-CHPS/CHVA AMT-FAC 98";
label variable OPOOFD98 "OPD NON-DR VISITS-OTHER FED AMT-FAC 98";
label variable OPOSTL98 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 98";
label variable OPOWCP98 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 98";
label variable OPOOPR98 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 98";
label variable OPOOPU98 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 98";
label variable OPOOSR98 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 98";
label variable OPPEXP98 "TOTAL OUTPATIENT NON-DR - DR EXP 98";
label variable OPPTCH98 "OPD NON-PHYS VISIT CHARGES - DR 98";
label variable OPPSLF98 "OPD NON-DR VISITS-SELF/FAM AMT-DR 98";
label variable OPPMCR98 "OPD NON-DR VISITS-MEDICARE AMT-DR 98";
label variable OPPMCD98 "OPD NON-DR VISITS-MEDICAID AMT-DR 98";
label variable OPPPRV98 "OPD NON-DR VISITS-PRIV INS AMT-DR 98";
label variable OPPVA98 "OPD NON-DR VISITS-VA AMT-DR 98";
label variable OPPCHM98 "OPD NON-DR VISITS-CHPS/CHVA AMT-DR 98";
label variable OPPOFD98 "OPD NON-DR VISITS-OTHER FED AMT-DR 98";
label variable OPPSTL98 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 98";
label variable OPPWCP98 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 98";
label variable OPPOPR98 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 98";
label variable OPPOPU98 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 98";
label variable OPPOSR98 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 98";
label variable AMCHIR98 "# CHIROPRACTR VSTS (OFF+OUTPAT), 1998";
label variable AMCTCH98 "CHIRO AMBULATORY VISIT CHARGES 98";
label variable AMCEXP98 "TOTL AMBULTRY (OB+OP) CHIRO EXP 98";
label variable AMCSLF98 "CHIRO AMB VISITS -SELF/FAMILY AMT 98";
label variable AMCMCR98 "CHIRO AMB VISITS -MEDICARE AMT 98";
label variable AMCMCD98 "CHIRO AMB VISITS -MEDICAID AMT 98";
label variable AMCPRV98 "CHIRO AMB VISITS -PRIVATE INS AMT 98";
label variable AMCVA98 "CHIRO AMB VISITS -VA AMT 98";
label variable AMCCHM98 "CHIRO AMB VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable AMCOFD98 "CHIRO AMB VISITS -OTHER FEDERAL AMT 98";
label variable AMCSTL98 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 98";
label variable AMCWCP98 "CHIRO AMB VISITS-WORKERS COMP AMT 98";
label variable AMCOPR98 "CHIRO AMB VISITS - OTH PRIVATE AMT 98";
label variable AMCOPU98 "CHIRO AMB VISITS - OTH PUBLIC AMT 98";
label variable AMCOSR98 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 98";
label variable AMNURS98 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 98";
label variable AMNTCH98 "NRS/PRAC AMBULATORY VISIT CHARGES 98";
label variable AMNEXP98 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 98";
label variable AMNSLF98 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 98";
label variable AMNMCR98 "NRS/PRAC AMB VSTS -MEDICARE AMT 98";
label variable AMNMCD98 "NRS/PRAC AMB VSTS -MEDICAID AMT 98";
label variable AMNPRV98 "NRS/PRAC AMB VSTS -PRIV INS AMT 98";
label variable AMNVA98 "NRS/PRAC AMB VSTS-VA AMT 98";
label variable AMNCHM98 "NRS/PRAC AMB VSTS-CHAMPUS/CHAMPVA AMT 98";
label variable AMNOFD98 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 98";
label variable AMNSTL98 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 98";
label variable AMNWCP98 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 98";
label variable AMNOPR98 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 98";
label variable AMNOPU98 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 98";
label variable AMNOSR98 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 98";
label variable AMOPTO98 "# AMB OPTOMETRIST VSTS (OB+OP) 98";
label variable AMETCH98 "OPTOMETRIST AMBULATORY VISIT CHARGES 98";
label variable AMEEXP98 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 98";
label variable AMESLF98 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 98";
label variable AMEMCR98 "OPTMTRIST AMB VSTS -MEDICARE AMT 98";
label variable AMEMCD98 "OPTMTRIST AMB VSTS -MEDICAID AMT 98";
label variable AMEPRV98 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 98";
label variable AMEVA98 "OPTMTRIST AMB VSTS-VA AMT 98";
label variable AMECHM98 "OPTMTRIST AMB VSTS-CHMPUS/CHMPVA AMT 98";
label variable AMEOFD98 "OPTMTRIST AMB VSTS-OTHER FED AMT 98";
label variable AMESTL98 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 98";
label variable AMEWCP98 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 98";
label variable AMEOPR98 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 98";
label variable AMEOPU98 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 98";
label variable AMEOSR98 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 98";
label variable AMASST98 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 1998";
label variable AMATCH98 "PHYS ASS T AMBULATORY VISIT CHARGES 98";
label variable AMAEXP98 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 98";
label variable AMASLF98 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 98";
label variable AMAMCR98 "PHYS ASS T AMB VSTS-MEDICARE AMT 98";
label variable AMAMCD98 "PHYS ASS T AMB VSTS-MEDICAID AMT 98";
label variable AMAPRV98 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 98";
label variable AMAVA98 "PHYS ASS T AMB VSTS-VA AMT 98";
label variable AMACHM98 "PHYS ASS T AMB VSTS-CHMPUS/CHMPVA AMT 98";
label variable AMAOFD98 "PHYS ASS T AMB VSTS -OTHER FED AMT 98";
label variable AMASTL98 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 98";
label variable AMAWCP98 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 98";
label variable AMAOPR98 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 98";
label variable AMAOPU98 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 98";
label variable AMAOSR98 "P A AMB VSTS- OTH UNCLASS SRCE AMT 98";
label variable AMTHER98 "# AMB PT/OT THRPY VISITS (OB+OP) 98";
label variable AMTTCH98 "PT/OC AMBULATORY VISIT CHARGES 98";
label variable AMTEXP98 "TOTL AMBULTRY (OB+OP) PT/OT EXP 98";
label variable AMTSLF98 "PT/OT AMB VISITS-SELF/FAMILY AMT 98";
label variable AMTMCR98 "PT/OT AMB VISITS-MEDICARE AMT 98";
label variable AMTMCD98 "PT/OT AMB VISITS-MEDICAID AMT 98";
label variable AMTPRV98 "PT/OT AMB VISITS-PRIVATE INS AMT 98";
label variable AMTVA98 "PT/OT AMB VISITS-VA AMT 98";
label variable AMTCHM98 "PT/OT AMB VISITS-CHAMPUS/CHAMPVA AMT 98";
label variable AMTOFD98 "PT/OT AMB VISITS -OTHER FED AMT 98";
label variable AMTSTL98 "PT/OT AMB VISITS-OTH ST/LOCL AMT 98";
label variable AMTWCP98 "PT/OT AMB VISITS-WORKERS COMP AMT 98";
label variable AMTOPR98 "PT/OT AMB VISITS - OTH PRIVATE AMT 98";
label variable AMTOPU98 "PT/OT AMB VISITS-OTH PUBLIC AMT 98";
label variable AMTOSR98 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 98";
label variable AMTOTC98 "# CALLS W/OFFICE & OUPAT DEPTS, 1998";
label variable AMDRC98 "# CALLS W/OFF & OUTPAT PHYSICIANS, 1998";
label variable ERTOT98 "# EMERGENCY ROOM VISITS 98";
label variable ERFTCH98 "ER FACILITY VISIT CHARGES 98";
label variable ERFEXP98 "TOTAL ER FACILITY EXP 98";
label variable ERFSLF98 "ER-SELF/FAMILY AMT - FAC 98";
label variable ERFMCR98 "ER-MEDICARE AMT - FAC 98";
label variable ERFMCD98 "ER-MEDICAID AMT - FAC 98";
label variable ERFPRV98 "ER-PRIVATE INS AMT - FAC 98";
label variable ERFVA98 "ER-VA AMT - FAC 98";
label variable ERFCHM98 "ER-CHAMPUS/CHAMPVA AMT - FAC 98";
label variable ERFOFD98 "ER-OTHER FEDERAL AMT - FAC 98";
label variable ERFSTL98 "ER-OTH ST/LOCAL AMT - FAC 98";
label variable ERFWCP98 "ER-WORKERS COMP AMT - FAC 98";
label variable ERFOPR98 "ER-OTHER PRIVATE AMT - FAC 98";
label variable ERFOPU98 "ER-OTHER PUBLIC AMT - FAC 98";
label variable ERFOSR98 "ER-OTH UNCLASS SRCE AMT - FAC 98";
label variable ERDEXP98 "TOTAL EMERGENCY ROOM DR EXP 98";
label variable ERDTCH98 "ER DOCTOR VISIT CHARGES 98";
label variable ERDSLF98 "ER-SELF/FAMILY AMT - DR 98";
label variable ERDMCR98 "ER-MEDICARE AMT - DR 98";
label variable ERDMCD98 "ER-MEDICAID AMT - DR 98";
label variable ERDPRV98 "ER-PRIVATE INS AMT - DR 98";
label variable ERDVA98 "ER-VA AMT - DR 98";
label variable ERDCHM98 "ER-CHAMPUS/CHAMPVA AMT - DR 98";
label variable ERDOFD98 "ER-OTHER FED AMT - DR 98";
label variable ERDSTL98 "ER-OTH ST/LOCAL AMT - DR 98";
label variable ERDWCP98 "ER-WORKERS COMP AMT - DR 98";
label variable ERDOPR98 "ER - OTHER PRIVATE AMT - DR 98";
label variable ERDOPU98 "ER - OTHER PUBLIC AMT - DR 98";
label variable ERDOSR98 "ER-OTH UNCLASS SRCE AMT - DR 98";
label variable IPZERO98 "# ZERO-NIGHT HOSPITAL STAYS 98";
label variable ZIFTCH98 "ZERO-NITE IP STAY CHARGES - FAC 98";
label variable ZIFEXP98 "TOTAL ZERO-NITE STAYS FAC EXP 98";
label variable ZIFSLF98 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 98";
label variable ZIFMCR98 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 98";
label variable ZIFMCD98 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 98";
label variable ZIFPRV98 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 98";
label variable ZIFVA98 "ZERO-NITE IP STAZ-VA AMT-FAC 98";
label variable ZIFCHM98 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-FAC 98";
label variable ZIFOFD98 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 98";
label variable ZIFSTL98 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 98";
label variable ZIFWCP98 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 98";
label variable ZIFOPR98 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 98";
label variable ZIFOPU98 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 98";
label variable ZIFOSR98 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 98";
label variable ZIDEXP98 "TOTAL ZERO-NITE STAZ DR 98";
label variable ZIDTCH98 "ZERO-NITE IP STAY CHARGES - DR 98";
label variable ZIDSLF98 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 98";
label variable ZIDMCR98 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 98";
label variable ZIDMCD98 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 98";
label variable ZIDPRV98 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 98";
label variable ZIDVA98 "ZERO-NITE IP STAZ-VA AMT-DR 98";
label variable ZIDCHM98 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-DR 98";
label variable ZIDOFD98 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 98";
label variable ZIDSTL98 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 98";
label variable ZIDWCP98 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 98";
label variable ZIDOPR98 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 98";
label variable ZIDOPU98 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 98";
label variable ZIDOSR98 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 98";
label variable IPDIS98 "# HOSPITAL DISCHARGES, 1998";
label variable IPFEXP98 "TOT HOSP IP FACILITY EXP-INC 0 NITES 98";
label variable IPFTCH98 "IP HOSP STAY CHARGES - FAC 98";
label variable IPFSLF98 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 98";
label variable IPFMCR98 "IP HOSP STAZ-MEDICARE AMT-FAC 98";
label variable IPFMCD98 "IP HOSP STAZ-MEDICAID AMT-FAC 98";
label variable IPFPRV98 "IP HOSP STAZ-PRIV INS AMT-FAC 98";
label variable IPFVA98 "IP HOSP STAZ-VA AMT-FAC 98";
label variable IPFCHM98 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-FAC 98";
label variable IPFOFD98 "IP HOSP STAZ-OTHER FED AMT-FAC 98";
label variable IPFSTL98 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 98";
label variable IPFWCP98 "IP HOSP STAZ-WORKERS COMP AMT-FAC 98";
label variable IPFOPR98 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 98";
label variable IPFOPU98 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 98";
label variable IPFOSR98 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 98";
label variable IPDEXP98 "TOTL HOSP STAZ DR EXP 98";
label variable IPDTCH98 "IP HOSP STAY CHARGES - DR 98";
label variable IPDSLF98 "IP HOSP STAZ-SELF/FAMILY AMT-DR 98";
label variable IPDMCR98 "IP HOSP STAZ-MEDICARE AMT- DR 98";
label variable IPDMCD98 "IP HOSP STAZ-MEDICAID AMT-DR 98";
label variable IPDPRV98 "IP HOSP STAZ-PRIV INS AMT- DR 98";
label variable IPDVA98 "IP HOSP STAZ-VA AMT-DR 98";
label variable IPDCHM98 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-DR 98";
label variable IPDOFD98 "IP HOSP STAZ-OTHER FED AMT-DR 98";
label variable IPDSTL98 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 98";
label variable IPDWCP98 "IP HOSP STAZ-WORKERS COMP AMT-DR 98";
label variable IPDOPR98 "IP HOSP STAZ - OTH PRIVATE AMT-DR 98";
label variable IPDOPU98 "IP HOSP STAZ - OTH PUBLIC AMT-DR 98";
label variable IPDOSR98 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 98";
label variable IPNGTD98 "# NIGHTS IN HOSP FOR DISCHARGES, 1998";
label variable DVTOT98 "# DENTAL CARE VISITS 98";
label variable DVTTCH98 "TOTAL DENTAL CARE VISIT CHARGES 98";
label variable DVTEXP98 "TOTAL DENTAL CARE EXP 98";
label variable DVTSLF98 "ALL DENTAL CARE -SELF/FAMILY AMT 98";
label variable DVTMCR98 "ALL DENTAL CARE -MEDICARE AMT 98";
label variable DVTMCD98 "ALL DENTAL CARE -MEDICAID AMT 98";
label variable DVTPRV98 "ALL DENTAL CARE -PRIVATE INS AMT 98";
label variable DVTVA98 "ALL DENTAL CARE-VA AMT 98";
label variable DVTCHM98 "ALL DENTAL CARE-CHAMPUS/CHAMPVA AMT 98";
label variable DVTOFD98 "ALL DENTAL CARE -OTHER FEDRL AMT 98";
label variable DVTSTL98 "ALL DENTAL CARE-OTH ST/LOCAL AMT 98";
label variable DVTWCP98 "ALL DENTAL CARE-WORKERS COMP AMT 98";
label variable DVTOPR98 "ALL DENTAL CARE - OTH PRIVATE AMT 98";
label variable DVTOPU98 "ALL DENTAL CARE - OTH PUBLIC AMT 98";
label variable DVTOSR98 "ALL DENT CARE-OT UNCLASS SRCE AMT 98";
label variable DVGEN98 "# GENERAL DENTIST VISITS 98";
label variable DVGTCH98 "GENERAL DENTAL CARE VISIT CHARGES 98";
label variable DVGEXP98 "TOTAL GENERAL DENTIST EXP 98";
label variable DVGSLF98 "GNRL DENTAL VISITS -SELF/FAM AMT 98";
label variable DVGMCR98 "GNRL DENTAL VISITS -MEDICARE AMT 98";
label variable DVGMCD98 "GNRL DENTAL VISITS -MEDICAID AMT 98";
label variable DVGPRV98 "GNRL DENTAL VISITS -PRIVATE INS AMT 98";
label variable DVGVA98 "GNRL DENTAL VISITS -VA AMT 98";
label variable DVGCHM98 "GNRL DENTAL VISITS-CHMPUS/CHMPVA AMT 98";
label variable DVGOFD98 "GNRL DENTAL VISITS- OTHER FED AMT 98";
label variable DVGSTL98 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 98";
label variable DVGWCP98 "GNRL DENTAL VISITS - WORKERS COMP AMT 98";
label variable DVGOPR98 "GNRL DENTAL VISITS - OTH PRIVATE AMT 98";
label variable DVGOPU98 "GNRL DENTAL VISITS - OTH PUBLIC AMT 98";
label variable DVGOSR98 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 98";
label variable DVORTH98 "# ORTHODONTIST VISITS 98";
label variable DVOTCH98 "ORTHODONTIST VISIT CHARGES 98";
label variable DVOEXP98 "TOTAL ORTHODONTIST EXP 98";
label variable DVOSLF98 "ORTHODONTIST VISITS -SELF/FAMILY AMT 98";
label variable DVOMCR98 "ORTHODONTIST VISITS -MEDICARE AMT 98";
label variable DVOMCD98 "ORTHODONTIST VISITS -MEDICAID AMT 98";
label variable DVOPRV98 "ORTHODONTIST VISITS -PRIVATE INS AMT 98";
label variable DVOVA98 "ORTHODONTIST VISITS-VA AMT 98";
label variable DVOCHM98 "ORTHODONTIST VISITS-CHMPUS/CHMPVA AMT 98";
label variable DVOOFD98 "ORTHODONTIST VISITS-OTHR FED AMT 98";
label variable DVOSTL98 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 98";
label variable DVOWCP98 "ORTHODONTIST VISITS-WORKERS COMP AMT 98";
label variable DVOOPR98 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 98";
label variable DVOOPU98 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 98";
label variable DVOOSR98 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 98";
label variable HHTOTD98 "# HOME HEALTH PROVIDER DAYS, 1998";
label variable HHAGD98 "# AGENCY HOME HEALTH PROVIDER DAYS 98";
label variable HHATCH98 "HOME HEALTH AGENCY VISIT CHARGES 98";
label variable HHAEXP98 "TOTAL HOME HEALTH AGENCY EXP 98";
label variable HHASLF98 "HOME HLTH AGENCY -SELF/FAMILY AMT 98";
label variable HHAMCR98 "HOME HLTH AGENCY -MEDICARE AMT 98";
label variable HHAMCD98 "HOME HLTH AGENCY -MEDICAID AMT 98";
label variable HHAPRV98 "HOME HLTH AGENCY -PRIVATE INS AMT 98";
label variable HHAVA98 "HOME HLTH AGENCY-VA AMT 98";
label variable HHACHM98 "HOME HLTH AGENCY-CHAMPUS/CHAMPVA AMT 98";
label variable HHAOFD98 "HOME HLTH AGENCY-OTHER FED AMT 98";
label variable HHASTL98 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 98";
label variable HHAWCP98 "HOME HLTH AGENCY- WORKERS COMP AMT 98";
label variable HHAOPR98 "HOME HLTH AGENCY - OTH PRIVATE AMT 98";
label variable HHAOPU98 "HOME HLTH AGENCY - OTH PUBLIC AMT 98";
label variable HHAOSR98 "H HLTH AGENCY - OT UNCLASS SRCE AMT 98";
label variable HHINDD98 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 98";
label variable HHNTCH98 "HOME HEALTH NON-AGENCY VISIT CHARGES 98";
label variable HHNEXP98 "TOTAL HOME HEALTH NON-AGNCY EXP 98";
label variable HHNSLF98 "HOME HLTH NON-AGNCY -SELF/FAM AMT 98";
label variable HHNMCR98 "HOME HLTH NON-AGNCY -MEDICARE AMT 98";
label variable HHNMCD98 "HOME HLTH NON-AGNCY -MEDICAID AMT 98";
label variable HHNPRV98 "HOME HLTH NON-AGNCY -PRIV INS AMT 98";
label variable HHNVA98 "HOME HLTH NON-AGNCY-VA AMT 98";
label variable HHNCHM98 "HOME HLTH NON-AGNCY-CHMPUS/CHMPVA AMT 98";
label variable HHNOFD98 "HOME HLTH NON-AGNCY-OTHR FED AMT 98";
label variable HHNSTL98 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 98";
label variable HHNWCP98 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 98";
label variable HHNOPR98 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 98";
label variable HHNOPU98 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 98";
label variable HHNOSR98 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 98";
label variable HHINFD98 "# INFORMAL HOME HEALTH PROVIDER DAYS 98";
label variable VISEXP98 "TOTAL GLASSES/CONTACT LENS EXP 98";
label variable VISTCH98 "GLASSES/CONTACT LENSES CHARGES 98";
label variable VISSLF98 "GLASSES/CNTCT LENSES -SELF/FAM AMT 98";
label variable VISMCR98 "GLASSES/CNTCT LENSES-MEDICARE AMT 98";
label variable VISMCD98 "GLASSES/CNTCT LENSES-MEDICAID AMT 98";
label variable VISPRV98 "GLASSES/CNTCT LENSES-PRIV INS AMT 98";
label variable VISVA98 "GLASSES/CNTCT LENSES-VA AMT 98";
label variable VISCHM98 "GLASSES/LENSES-CHAMPUS/CHAMPVA AMT 98";
label variable VISOFD98 "GLASSES/CNTCT LENSES-OTHR FED AMT 98";
label variable VISSTL98 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 98";
label variable VISWCP98 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 98";
label variable VISOPR98 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 98";
label variable VISOPU98 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 98";
label variable VISOSR98 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 98";
label variable OTHTCH98 "OTHER EQUP/SUPPLIES CHARGES 98";
label variable OTHEXP98 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 98";
label variable OTHSLF98 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 98";
label variable OTHMCR98 "OTHER EQUP/SUPPLIES-MEDICARE AMT 98";
label variable OTHMCD98 "OTHER EQUP/SUPPLIES-MEDICAID AMT 98";
label variable OTHPRV98 "OTHER EQUP/SUPPLIES-PRIV INS AMT 98";
label variable OTHVA98 "OTHER EQUP/SUPPLY-VA AMT 98";
label variable OTHCHM98 "OTHER EQUP/SUPPLY-CHAMPUS/CHAMPVA AMT 98";
label variable OTHOFD98 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 98";
label variable OTHSTL98 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 98";
label variable OTHWCP98 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 98";
label variable OTHOPR98 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 98";
label variable OTHOPU98 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 98";
label variable OTHOSR98 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 98";
label variable RXTOT98 "# PRESC MEDS INCL REFILLS 98";
label variable RXEXP98 "TOTAL RX-EXP 98";
label variable RXSLF98 "TOTAL RX-SELF/FAMILY AMT 98";
label variable RXMCR98 "TOTAL RX--MEDICARE AMT 98";
label variable RXMCD98 "TOTAL RX-MEDICAID AMT 98";
label variable RXPRV98 "TOTAL RX-PRIVATE INS AMT 98";
label variable RXVA98 "TOTAL RX-VA AMT 98";
label variable RXCHM98 "TOTAL RX-CHAMPUS/CHAMPVA AMT 98";
label variable RXOFD98 "TOTAL RX-OTHER FED AMT 98";
label variable RXSTL98 "TOTAL RX-OTHER ST/LOCAL AMT 98";
label variable RXWCP98 "TOTAL RX-WORKERS COMP AMT 98";
label variable RXOPR98 "TOTAL RX - OTH PRIVATE AMT 98";
label variable RXOPU98 "TOTAL RX - OTH PUBLIC AMT 98";
label variable RXOSR98 "TOT RX-OTH UNCLASS SRCE AMT 98";
label variable WTDPER98 "POVERTY/MORTALITY/NH ADJ PERS LVL WGT 98";
label variable WTFAMF98 "POVERTY ADJUSTED FAMILY WEIGHT";
label variable WTCFAM98 "POV ADJ FAMILY WGT-CPS FAM ON 12/31/98";
label variable VARSTR98 "VARIANCE ESTIMATION STRATUM - 1998";
label variable VARPSU98 "VARIANCE ESTIMATION PSU - 1998";


*DEFINE VALUE LABELS FOR REPORTS;
label define H280001X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H280003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H280004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H280005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280015X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 $1 - $100"
         2 "2 $101 - $500"
         3 "3 $501 - $1500"
         4 "4 $1501 - $3000"
         5 "5 $3001 - $5000"
         6 "6 $5001 OR MORE" ;

label define H280019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 1 TIME"
         2 "2 2-4 TIMES"
         3 "3 5-10 TIMES"
         4 "4 11-20 TIMES"
         5 "5 21-30 TIMES"
         6 "6 31 OR MORE TIMES" ;

label define H280021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280054X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         17 "$17 - $17" ;

label define H280055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280074X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3 "$3 - $3" ;

label define H280075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280091X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         8 "$8 - $8" ;

label define H280092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280113X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280114X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H280120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H280121X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H280122X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED IN ATTENDANCE"
         2 "2 UNABLE TO ATTEND"
         3 "3 NEITHER" ;

label define H280125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280129X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H280130X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H280131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280136X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280142X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280143X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280147X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H280148X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H280149X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H280150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H280153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H280154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H280155X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H280156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280158X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H280163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER" ;

label define H280164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H280166X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H280167X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H280168X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H280169X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H280173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H280174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAVE NO REGULAR DOCTOR"
         4 "4 ALTERNATIVE CARE PRACTITIONER" ;

label define H280176X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280177X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280179X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280180X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280184X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280185X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280186X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280188X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280189X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280190X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280191X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280192X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280193X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280194X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         230 "$230 - $230" ;

label define H280195X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1200 "$1200 - $1200" ;

label define H280196X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280197X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280198X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280199X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280200X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280201X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280202X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280203X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280204X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280205X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         60 "$60 - $60" ;

label define H280206X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280207X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280208X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280209X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280210X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280211X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280212X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280213X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280214X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280215X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280216X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280217X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280218X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280219X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280220X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H280222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H280223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H280224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H280225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H280226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H280227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H280228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H280229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H280230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H280231X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 NOT ELIG/NOT LINKED TO RESPONDING RU" ;

label define H280232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H280233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT DETERMINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H280234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H280235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H280243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1998 "1998 YEAR"
         1999 "1999 YEAR" ;

label define H280247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280248X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280249X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE CONSISTENTLY VARIES" ;

label define H280250X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280251X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280252X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280253X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280254X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         23 "$23 - $23" ;

label define H280255X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280256X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280257X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280258X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280259X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280260X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         120 "$120" ;

label define H280261X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280262X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280263X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280264X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280265X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280266X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280267X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280268X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280269X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280270X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280271X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280272X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280273X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280274X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280275X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280276X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280277X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280278X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280282X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H280283X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H280284X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H280285X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H280286X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         17 "17 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H280287X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280288X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H280289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H280291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H280292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280293X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H280294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H280297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         12 "12 FULL YEAR" ;

label define H280298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H280300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H280301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H280302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H280303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H280304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO FY FAM. WEIGHT & NO PERS WEIGHT"
         1 "1 FY RESP. FAM. PRESENT ON 12-31-98, K/I"
         2 "2 FY RESP. FAM. NOT PRES 12-31-98, K/I"
         3 "3 FY RESP.FAM. NOT PRES 12-31 NO K/I"
         4 "4 NO FY RESP. FAM. WGT BUT HAS PERS WGT" ;

label define H280305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H280306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280310X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H280311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280333X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         450 "$450 - $450" ;

label define H280334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280337X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280338X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280342X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280343X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         801 "$801 - $801" ;

label define H280344X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280345X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280346X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280347X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280348X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280349X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280350X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         35 "$35 - $35" ;

label define H280351X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H280353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H280354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H280355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H280356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H280357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC" ;

label define H280358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H280359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280362X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280363X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280364X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280437X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H280438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H280439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H280440X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $48.08"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280441X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $48.08"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280442X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $48.08"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280443X
         0 "0 NO"
         1 "1 YES" ;

label define H280444X
         0 "0 NO"
         1 "1 YES" ;

label define H280445X
         0 "0 NO"
         1 "1 YES" ;

label define H280446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280452X
         0 "0 NON-RESPONSE"
         1 "1 YES"
         2 "2 NO" ;

label define H280453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         95 "95 DOES NOT HAVE HEALTH INSURANCE" ;

label define H280454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/1998"
         2 "2 NOT IN-SCOPE ON 12/31/1998" ;

label define H280457X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/98"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H280458X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/98"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H280459X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/98"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H280460X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/98"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H280461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 1998"
         2 "2 OUT-OF-SCOPE FOR ALL OF 1998" ;

label define H280462X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H280463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280465X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280466X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280467X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280470X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280473X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280482X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280483X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280484X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280485X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280486X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280487X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280488X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280489X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280490X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280491X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280492X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280493X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280494X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280495X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280496X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280497X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280498X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280499X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280500X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280501X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280502X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280503X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280504X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280505X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280506X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280507X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280509X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H280510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H280511X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H280512X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H280513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280514X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H280515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN  PAST YEAR"
         2 "2 WITHIN  PAST 2 YEARS"
         3 "3 WITHIN THE PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND 3/1"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND 3/1"
         8 "8 WIDOWED IN ROUND 3/1"
         9 "9 DIVORCED IN ROUND 3/1" ;

label define H280524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND 4/2"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND 4/2"
         8 "8 WIDOWED IN ROUND 4/2"
         9 "9 DIVORCED IN ROUND 4/2" ;

label define H280525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND 5/3"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 INAPPLICABLE"
         7 "7 MARRIED IN ROUND 5/3"
         8 "8 WIDOWED IN ROUND 5/3"
         9 "9 DIVORCED IN ROUND 5/3" ;

label define H280526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H280527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280545X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280573X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280574X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280575X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280576X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280580X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280581X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H280582X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280583X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280584X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280585X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H280586X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H280587X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H280588X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H280589X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H280590X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H280591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280593X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280594X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H280596X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H280597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H280598X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H280599X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H280600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H280601X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H280602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H280603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H280604X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280605X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280606X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H280608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280610X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H280611X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H280612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H280613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280637X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280638X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280640X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280641X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280642X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280643X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280644X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280646X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280647X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280648X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280651X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280656X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280657X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280658X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         17 "$17 - $17" ;

label define H280659X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280662X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280663X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280664X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280665X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280666X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280667X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280668X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280669X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280670X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280671X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280672X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280673X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280674X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280675X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280676X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280677X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280678X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3 "$3 - $3" ;

label define H280679X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280680X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280681X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280682X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280683X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280684X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280685X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280686X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280687X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280688X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280689X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280691X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280692X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280698X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280699X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280700X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280701X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280702X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280703X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280704X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280705X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280706X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280707X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280708X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280709X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280710X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280711X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280712X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280713X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280714X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280715X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280716X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280717X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         13 "$13 - $13" ;

label define H280718X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280719X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280720X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280721X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280722X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280723X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280724X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280725X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280726X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280727X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280728X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280729X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280730X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280731X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280732X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280733X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280734X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280735X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280736X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280737X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280738X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280739X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280740X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280759X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280760X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280761X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280767X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         29 "$29 - $29" ;

label define H280768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280774X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280776X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280777X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280778X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280779X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280780X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280781X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280782X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280783X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280784X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280785X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280786X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280787X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280788X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280789X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280790X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280792X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280798X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280811X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         29 "$29 - $29" ;

label define H280812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280814X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         115 "$115 - $115" ;

label define H280815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280817X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         178 "$178 - $178" ;

label define H280818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280825X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         57 "$57 - $57" ;

label define H280826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280831X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         15 "$15 - $15" ;

label define H280832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280850X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280853X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280858X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         198 "$198 - $198" ;

label define H280859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280863X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H280867X
         2 "2 PANEL 2"
         3 "3 PANEL 3" ;

label define H280868X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280869X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280870X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280872X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280873X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280874X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280875X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280876X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280877X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280878X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280879X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280880X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280881X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280882X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280883X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280884X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280885X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280886X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280887X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280888X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280889X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280890X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280891X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280892X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280893X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280894X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280895X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280896X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280897X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280898X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280899X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280900X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280901X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280902X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280903X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280904X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280905X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280906X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280907X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280908X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280914X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280915X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280916X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280917X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280918X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280919X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280920X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280921X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280922X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280923X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280924X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280926X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280927X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280928X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280929X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280930X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280931X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280932X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280933X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280934X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280935X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280936X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280937X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280938X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280939X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280940X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280941X
         1 "1 NEGATIVE OR POOR"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H280942X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 $1 - $50"
         2 "2 $51 - $100"
         3 "3 $101 - $200"
         4 "4 $201 - $500"
         5 "5 $501 OR MORE" ;

label define H280943X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H280944X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280945X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280946X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280947X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280948X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280951X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280952X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280953X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280954X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280955X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280956X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H280957X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H280958X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H280959X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H280960X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H280961X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280962X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280963X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280964X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280965X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280966X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280967X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280968X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280969X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280970X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280971X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280972X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280973X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280974X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H280975X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H280976X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H280977X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280978X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280979X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280980X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280981X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280982X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H280983X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280984X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280985X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280986X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280987X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280988X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280989X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280990X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280991X
         -1 "-1 NO RD 2 CROSSOVER PROBLEM"
         1 "1 RD 2 ENDS IN 1999; RD 3 BEGINS IN 1999"
         2 "2 NO RD 2; RD 3 BEGINS IN 1999"
         3 "3 RD 2 ENDS IN 1998; RD 3 BEGINS IN 1999"
         4 "4 RD 2 ENDS IN 1999; RD 3 BEGINS IN 1998" ;

label define H280992X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H280993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H280994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280995X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H280996X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H280997X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280998X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H280999X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H281000X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281001X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         95 "95 CARE PROVIDED BY REGULAR PROVIDER" ;

label define H281002X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H281003X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H281004X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H281005X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H281006X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H281007X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H281008X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H281009X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H281010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281011X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281012X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H281014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H281015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H281016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H281017X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H281018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H281019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H281020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H281021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H281022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H281023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H281024X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H281025X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H281026X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H281027X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H281028X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H281029X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H281030X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H281031X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H281032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281046X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281053X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281054X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H281056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281057X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281058X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281061X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281062X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H281066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, SPECIAL PROGRAM"
         2 "2 YES, EARLY INTERVENTION SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H281067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, ENROLLED IN SPECIAL EDUCATION"
         2 "2 YES, RELATED SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H281069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281070X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H281071X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H281072X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H281073X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H281074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H281075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H281076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H281077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H281078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281079X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABLILITY"
         2 "2 SOME OTHER REASON" ;

label define H281082X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281096X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281097X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN A PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H281099X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H281100X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H281101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281102X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281103X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H281105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H281106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETLY UNABLE TO WALK" ;

label define H281107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H281108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORAM 1040EZ"
         91 "91 OTHER" ;

label define H281109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H281111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281126X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H281128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281130X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H281133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281135X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281136X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281137X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H281139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H281140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H281141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H281142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H281143X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281145X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H281146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281147X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281149X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281153X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281154X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281155X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281156X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281157X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H281159X
         -9 "-9 NOT ASCERTAINED"
         0 "$0.00" ;

label define H281160X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281161X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H281162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H281164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RELATIVE"
         2 "2 NON-RELATIVE" ;

label define H281165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CHILD'S HOME"
         2 "2 OTHER PRIVATE HOME"
         3 "3 NURSERY, PRESCHOOL"
         4 "4 ORG (BEFORE/AFTER) SCHOOL ACTIVITIES"
         5 "5 DAY CARE CENTER, NOT AT PARENT'S WORK"
         6 "6 DAY CARE CENTER, AT PARENT'S WORKPLACE"
         7 "7 PARENT WATCHES CHILD AT WORK"
         91 "91 SOME OTHER ARRANGEMENT" ;

label define H281166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H281168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H281169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H281175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H281176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H281177X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281179X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281180X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281184X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281185X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281186X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281188X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281189X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281190X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281191X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281192X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281193X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281194X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281195X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281196X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281197X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281198X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281199X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281200X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281201X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281202X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281203X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H281204X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1383 "$1383 - $1383" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACPTHE98 H280001X;
label value ACTDTY31 H280002X;
label value ACTDTY42 H280003X;
label value ACTDTY53 H280004X;
label value ACTLIM31 H280005X;
label value ACTLIM53 H280006X;
label value ACUPNC98 H280007X;
label value ADLHLP31 H280008X;
label value ADLHLP42 H280009X;
label value ADLHLP53 H280010X;
label value ADUPRO42 H280011X;
label value AFDC98 H280012X;
label value AIDHLP31 H280013X;
label value AIDHLP53 H280014X;
label value ALIIMP98 H280015X;
label value ALTCAR98 H280016X;
label value ALTCRE98 H280017X;
label value ALTCRX98 H280018X;
label value ALTCSP98 H280019X;
label value ALTCVE98 H280020X;
label value ALTCVS98 H280021X;
label value ALTOTH98 H280022X;
label value AMACHM98 H280023X;
label value AMAEXP98 H280024X;
label value AMAMCD98 H280025X;
label value AMAMCR98 H280026X;
label value AMAOFD98 H280027X;
label value AMAOPR98 H280028X;
label value AMAOPU98 H280029X;
label value AMAOSR98 H280030X;
label value AMAPRV98 H280031X;
label value AMASLF98 H280032X;
label value AMASST98 H280033X;
label value AMASTL98 H280034X;
label value AMATCH98 H280035X;
label value AMAVA98 H280036X;
label value AMAWCP98 H280037X;
label value AMCCHM98 H280038X;
label value AMCEXP98 H280039X;
label value AMCHIR98 H280040X;
label value AMCMCD98 H280041X;
label value AMCMCR98 H280042X;
label value AMCOFD98 H280043X;
label value AMCOPR98 H280044X;
label value AMCOPU98 H280045X;
label value AMCOSR98 H280046X;
label value AMCPRV98 H280047X;
label value AMCSLF98 H280048X;
label value AMCSTL98 H280049X;
label value AMCTCH98 H280050X;
label value AMCVA98 H280051X;
label value AMCWCP98 H280052X;
label value AMDRC98 H280053X;
label value AMECHM98 H280054X;
label value AMEEXP98 H280055X;
label value AMEMCD98 H280056X;
label value AMEMCR98 H280057X;
label value AMEOFD98 H280058X;
label value AMEOPR98 H280059X;
label value AMEOPU98 H280060X;
label value AMEOSR98 H280061X;
label value AMEPRV98 H280062X;
label value AMESLF98 H280063X;
label value AMESTL98 H280064X;
label value AMETCH98 H280065X;
label value AMEVA98 H280066X;
label value AMEWCP98 H280067X;
label value AMNCHM98 H280068X;
label value AMNEXP98 H280069X;
label value AMNMCD98 H280070X;
label value AMNMCR98 H280071X;
label value AMNOFD98 H280072X;
label value AMNOPR98 H280073X;
label value AMNOPU98 H280074X;
label value AMNOSR98 H280075X;
label value AMNPRV98 H280076X;
label value AMNSLF98 H280077X;
label value AMNSTL98 H280078X;
label value AMNTCH98 H280079X;
label value AMNURS98 H280080X;
label value AMNVA98 H280081X;
label value AMNWCP98 H280082X;
label value AMOPTO98 H280083X;
label value AMTCHM98 H280084X;
label value AMTEXP98 H280085X;
label value AMTHER98 H280086X;
label value AMTMCD98 H280087X;
label value AMTMCR98 H280088X;
label value AMTOFD98 H280089X;
label value AMTOPR98 H280090X;
label value AMTOPU98 H280091X;
label value AMTOSR98 H280092X;
label value AMTOTC98 H280093X;
label value AMTPRV98 H280094X;
label value AMTSLF98 H280095X;
label value AMTSTL98 H280096X;
label value AMTTCH98 H280097X;
label value AMTVA98 H280098X;
label value AMTWCP98 H280099X;
label value ANYLIM98 H280100X;
label value BEGRFD31 H280101X;
label value BEGRFD42 H280102X;
label value BEGRFD53 H280103X;
label value BEGRFM31 H280104X;
label value BEGRFM42 H280105X;
label value BEGRFM53 H280106X;
label value BEGRFY31 H280107X;
label value BEGRFY42 H280108X;
label value BEGRFY53 H280109X;
label value BENDIF31 H280110X;
label value BENDIF53 H280111X;
label value BGNWK31 H280112X;
label value BGNWK42 H280113X;
label value BGNWK53 H280114X;
label value BIOFDB98 H280115X;
label value BLDPCK98 H280116X;
label value BLIND42 H280117X;
label value BRSTEX98 H280118X;
label value BSNTY31 H280119X;
label value BSNTY42 H280120X;
label value BSNTY53 H280121X;
label value BUSIMP98 H280122X;
label value CANTPL42 H280123X;
label value CANTSC42 H280124X;
label value CHAP98X H280125X;
label value CHAU98X H280126X;
label value CHDE98X H280127X;
label value CHFE98X H280128X;
label value CHGJ3142 H280129X;
label value CHGJ4253 H280130X;
label value CHIRO98 H280131X;
label value CHJA98X H280132X;
label value CHJL98X H280133X;
label value CHJU98X H280134X;
label value CHLIM42 H280135X;
label value CHLIMP98 H280136X;
label value CHMA98X H280137X;
label value CHMY98X H280138X;
label value CHNO98X H280139X;
label value CHOC98X H280140X;
label value CHOIC31 H280141X;
label value CHOIC42 H280142X;
label value CHOIC53 H280143X;
label value CHOLCK98 H280144X;
label value CHPEV98 H280145X;
label value CHSE98X H280146X;
label value CIND31 H280147X;
label value CIND42 H280148X;
label value CIND53 H280149X;
label value CLERGY98 H280150X;
label value CLMDEP98 H280151X;
label value CLMHIP98 H280152X;
label value COCCP31 H280153X;
label value COCCP42 H280154X;
label value COCCP53 H280155X;
label value COGLIM31 H280156X;
label value COGLIM53 H280157X;
label value CSHIMP98 H280158X;
label value DADPRO42 H280159X;
label value DAYCAR98 H280160X;
label value DEAF42 H280161X;
label value DEDUCT98 H280162X;
label value DENTCK98 H280163X;
label value DEPDNT98 H280164X;
label value DIDSERVE H280165X;
label value DISVW31X H280166X;
label value DISVW42X H280167X;
label value DISVW53X H280168X;
label value DIVIMP98 H280169X;
label value DOBMM H280170X;
label value DOBYY H280171X;
label value DPINRU98 H280172X;
label value DPOTSD98 H280173X;
label value DPTSHT42 H280174X;
label value DSCALT98 H280175X;
label value DVGCHM98 H280176X;
label value DVGEN98 H280177X;
label value DVGEXP98 H280178X;
label value DVGMCD98 H280179X;
label value DVGMCR98 H280180X;
label value DVGOFD98 H280181X;
label value DVGOPR98 H280182X;
label value DVGOPU98 H280183X;
label value DVGOSR98 H280184X;
label value DVGPRV98 H280185X;
label value DVGSLF98 H280186X;
label value DVGSTL98 H280187X;
label value DVGTCH98 H280188X;
label value DVGVA98 H280189X;
label value DVGWCP98 H280190X;
label value DVOCHM98 H280191X;
label value DVOEXP98 H280192X;
label value DVOMCD98 H280193X;
label value DVOMCR98 H280194X;
label value DVOOFD98 H280195X;
label value DVOOPR98 H280196X;
label value DVOOPU98 H280197X;
label value DVOOSR98 H280198X;
label value DVOPRV98 H280199X;
label value DVORTH98 H280200X;
label value DVOSLF98 H280201X;
label value DVOSTL98 H280202X;
label value DVOTCH98 H280203X;
label value DVOVA98 H280204X;
label value DVOWCP98 H280205X;
label value DVTCHM98 H280206X;
label value DVTEXP98 H280207X;
label value DVTMCD98 H280208X;
label value DVTMCR98 H280209X;
label value DVTOFD98 H280210X;
label value DVTOPR98 H280211X;
label value DVTOPU98 H280212X;
label value DVTOSR98 H280213X;
label value DVTOT98 H280214X;
label value DVTPRV98 H280215X;
label value DVTSLF98 H280216X;
label value DVTSTL98 H280217X;
label value DVTTCH98 H280218X;
label value DVTVA98 H280219X;
label value DVTWCP98 H280220X;
label value EDUCYR31 H280221X;
label value EDUCYR42 H280222X;
label value EDUCYR53 H280223X;
label value EDUCYR98 H280224X;
label value EICRDT98 H280225X;
label value ELDISC98 H280226X;
label value ELGRND31 H280227X;
label value ELGRND42 H280228X;
label value ELGRND53 H280229X;
label value ELGRND98 H280230X;
label value ELIGIBLE H280231X;
label value EMPST31 H280232X;
label value EMPST42 H280233X;
label value EMPST53 H280234X;
label value ENDRFD31 H280235X;
label value ENDRFD42 H280236X;
label value ENDRFD53 H280237X;
label value ENDRFD98 H280238X;
label value ENDRFM31 H280239X;
label value ENDRFM42 H280240X;
label value ENDRFM53 H280241X;
label value ENDRFM98 H280242X;
label value ENDRFY31 H280243X;
label value ENDRFY42 H280244X;
label value ENDRFY53 H280245X;
label value ENDRFY98 H280246X;
label value ENDWK31 H280247X;
label value ENDWK42 H280248X;
label value ENDWK53 H280249X;
label value ERDCHM98 H280250X;
label value ERDEXP98 H280251X;
label value ERDMCD98 H280252X;
label value ERDMCR98 H280253X;
label value ERDOFD98 H280254X;
label value ERDOPR98 H280255X;
label value ERDOPU98 H280256X;
label value ERDOSR98 H280257X;
label value ERDPRV98 H280258X;
label value ERDSLF98 H280259X;
label value ERDSTL98 H280260X;
label value ERDTCH98 H280261X;
label value ERDVA98 H280262X;
label value ERDWCP98 H280263X;
label value ERFCHM98 H280264X;
label value ERFEXP98 H280265X;
label value ERFMCD98 H280266X;
label value ERFMCR98 H280267X;
label value ERFOFD98 H280268X;
label value ERFOPR98 H280269X;
label value ERFOPU98 H280270X;
label value ERFOSR98 H280271X;
label value ERFPRV98 H280272X;
label value ERFSLF98 H280273X;
label value ERFSTL98 H280274X;
label value ERFTCH98 H280275X;
label value ERFVA98 H280276X;
label value ERFWCP98 H280277X;
label value ERTOT98 H280278X;
label value EVRETIRE H280279X;
label value EVRWRK H280280X;
label value FAMCNS42 H280281X;
label value FAMRFPYR H280282X;
label value FAMSZE31 H280283X;
label value FAMSZE42 H280284X;
label value FAMSZE53 H280285X;
label value FAMSZE98 H280286X;
label value FARIMP98 H280287X;
label value FCRP1231 H280288X;
label value FILEDR98 H280289X;
label value FILER98 H280290X;
label value FLSTAT98 H280291X;
label value FLUSHT98 H280292X;
label value FMRS1231 H280293X;
label value FNGRDF31 H280294X;
label value FNGRDF53 H280295X;
label value FOODCT98 H280296X;
label value FOODMN98 H280297X;
label value FOODST98 H280298X;
label value FOODVL98 H280299X;
label value FTSTU31X H280300X;
label value FTSTU42X H280301X;
label value FTSTU53X H280302X;
label value FTSTU98X H280303X;
label value FYFAMTYP H280304X;
label value GETSIC42 H280305X;
label value HAVFUN42 H280306X;
label value HEARAD42 H280307X;
label value HEARDI42 H280308X;
label value HEARMO42 H280309X;
label value HEARNG42 H280310X;
label value HEARSM42 H280311X;
label value HELD31X H280312X;
label value HELD42X H280313X;
label value HELD53X H280314X;
label value HEPSHT42 H280315X;
label value HERBAL98 H280316X;
label value HERBTR98 H280317X;
label value HGTFT42 H280318X;
label value HGTIN42 H280319X;
label value HHACHM98 H280320X;
label value HHAEXP98 H280321X;
label value HHAGD98 H280322X;
label value HHAMCD98 H280323X;
label value HHAMCR98 H280324X;
label value HHAOFD98 H280325X;
label value HHAOPR98 H280326X;
label value HHAOPU98 H280327X;
label value HHAOSR98 H280328X;
label value HHAPRV98 H280329X;
label value HHASLF98 H280330X;
label value HHASTL98 H280331X;
label value HHATCH98 H280332X;
label value HHAVA98 H280333X;
label value HHAWCP98 H280334X;
label value HHINDD98 H280335X;
label value HHINFD98 H280336X;
label value HHNCHM98 H280337X;
label value HHNEXP98 H280338X;
label value HHNMCD98 H280339X;
label value HHNMCR98 H280340X;
label value HHNOFD98 H280341X;
label value HHNOPR98 H280342X;
label value HHNOPU98 H280343X;
label value HHNOSR98 H280344X;
label value HHNPRV98 H280345X;
label value HHNSLF98 H280346X;
label value HHNSTL98 H280347X;
label value HHNTCH98 H280348X;
label value HHNVA98 H280349X;
label value HHNWCP98 H280350X;
label value HHTOTD98 H280351X;
label value HIDEG31 H280352X;
label value HIDEG42 H280353X;
label value HIDEG53 H280354X;
label value HIDEG98 H280355X;
label value HISPANX H280356X;
label value HISPCAT H280357X;
label value HLTHY42 H280358X;
label value HOMEBH42 H280359X;
label value HOMEMD98 H280360X;
label value HOMEO98 H280361X;
label value HOUR31 H280362X;
label value HOUR42 H280363X;
label value HOUR53 H280364X;
label value HPDAP98 H280365X;
label value HPDAU98 H280366X;
label value HPDDE98 H280367X;
label value HPDFE98 H280368X;
label value HPDJA98 H280369X;
label value HPDJL98 H280370X;
label value HPDJU98 H280371X;
label value HPDMA98 H280372X;
label value HPDMY98 H280373X;
label value HPDNO98 H280374X;
label value HPDOC98 H280375X;
label value HPDSE98 H280376X;
label value HPEAP98 H280377X;
label value HPEAU98 H280378X;
label value HPEDE98 H280379X;
label value HPEFE98 H280380X;
label value HPEJA98 H280381X;
label value HPEJL98 H280382X;
label value HPEJU98 H280383X;
label value HPEMA98 H280384X;
label value HPEMY98 H280385X;
label value HPENO98 H280386X;
label value HPEOC98 H280387X;
label value HPESE98 H280388X;
label value HPNAP98 H280389X;
label value HPNAU98 H280390X;
label value HPNDE98 H280391X;
label value HPNFE98 H280392X;
label value HPNJA98 H280393X;
label value HPNJL98 H280394X;
label value HPNJU98 H280395X;
label value HPNMA98 H280396X;
label value HPNMY98 H280397X;
label value HPNNO98 H280398X;
label value HPNOC98 H280399X;
label value HPNSE98 H280400X;
label value HPOAP98 H280401X;
label value HPOAU98 H280402X;
label value HPODE98 H280403X;
label value HPOFE98 H280404X;
label value HPOJA98 H280405X;
label value HPOJL98 H280406X;
label value HPOJU98 H280407X;
label value HPOMA98 H280408X;
label value HPOMY98 H280409X;
label value HPONO98 H280410X;
label value HPOOC98 H280411X;
label value HPOSE98 H280412X;
label value HPRAP98 H280413X;
label value HPRAU98 H280414X;
label value HPRDE98 H280415X;
label value HPRFE98 H280416X;
label value HPRJA98 H280417X;
label value HPRJL98 H280418X;
label value HPRJU98 H280419X;
label value HPRMA98 H280420X;
label value HPRMY98 H280421X;
label value HPRNO98 H280422X;
label value HPROC98 H280423X;
label value HPRSE98 H280424X;
label value HPSAP98 H280425X;
label value HPSAU98 H280426X;
label value HPSDE98 H280427X;
label value HPSFE98 H280428X;
label value HPSJA98 H280429X;
label value HPSJL98 H280430X;
label value HPSJU98 H280431X;
label value HPSMA98 H280432X;
label value HPSMY98 H280433X;
label value HPSNO98 H280434X;
label value HPSOC98 H280435X;
label value HPSSE98 H280436X;
label value HRHOW31 H280437X;
label value HRHOW42 H280438X;
label value HRHOW53 H280439X;
label value HRWG31X H280440X;
label value HRWG42X H280441X;
label value HRWG53X H280442X;
label value HRWGIM31 H280443X;
label value HRWGIM42 H280444X;
label value HRWGIM53 H280445X;
label value HSELIM31 H280446X;
label value HSELIM53 H280447X;
label value HYPNO98 H280448X;
label value IADLHP31 H280449X;
label value IADLHP42 H280450X;
label value IADLHP53 H280451X;
label value INRU1231 H280452X;
label value INSALT98 H280453X;
label value INSAP98X H280454X;
label value INSAU98X H280455X;
label value INSC1231 H280456X;
label value INSCOP31 H280457X;
label value INSCOP42 H280458X;
label value INSCOP53 H280459X;
label value INSCOP98 H280460X;
label value INSCOPE H280461X;
label value INSCOV98 H280462X;
label value INSDE98X H280463X;
label value INSFE98X H280464X;
label value INSJA98X H280465X;
label value INSJL98X H280466X;
label value INSJU98X H280467X;
label value INSMA98X H280468X;
label value INSMY98X H280469X;
label value INSNO98X H280470X;
label value INSOC98X H280471X;
label value INSSE98X H280472X;
label value INTIMP98 H280473X;
label value INTRTX98 H280474X;
label value IPDCHM98 H280475X;
label value IPDEXP98 H280476X;
label value IPDIS98 H280477X;
label value IPDMCD98 H280478X;
label value IPDMCR98 H280479X;
label value IPDOFD98 H280480X;
label value IPDOPR98 H280481X;
label value IPDOPU98 H280482X;
label value IPDOSR98 H280483X;
label value IPDPRV98 H280484X;
label value IPDSLF98 H280485X;
label value IPDSTL98 H280486X;
label value IPDTCH98 H280487X;
label value IPDVA98 H280488X;
label value IPDWCP98 H280489X;
label value IPFCHM98 H280490X;
label value IPFEXP98 H280491X;
label value IPFMCD98 H280492X;
label value IPFMCR98 H280493X;
label value IPFOFD98 H280494X;
label value IPFOPR98 H280495X;
label value IPFOPU98 H280496X;
label value IPFOSR98 H280497X;
label value IPFPRV98 H280498X;
label value IPFSLF98 H280499X;
label value IPFSTL98 H280500X;
label value IPFTCH98 H280501X;
label value IPFVA98 H280502X;
label value IPFWCP98 H280503X;
label value IPNGTD98 H280504X;
label value IPZERO98 H280505X;
label value IRAIMP98 H280506X;
label value IRATAX98 H280507X;
label value ITMEXP98 H280508X;
label value JNTPID98 H280509X;
label value JOBORG31 H280510X;
label value JOBORG42 H280511X;
label value JOBORG53 H280512X;
label value JTINRU98 H280513X;
label value KEYNESS H280514X;
label value KIDPRO42 H280515X;
label value LFTDIF31 H280516X;
label value LFTDIF53 H280517X;
label value LIFSKL42 H280518X;
label value LIMACT42 H280519X;
label value LMOACT42 H280520X;
label value LOSTEE98 H280521X;
label value MAMGRM98 H280522X;
label value MARRY31X H280523X;
label value MARRY42X H280524X;
label value MARRY53X H280525X;
label value MARRY98X H280526X;
label value MASAGE98 H280527X;
label value MASTHE98 H280528X;
label value MCDAP98 H280529X;
label value MCDAP98X H280530X;
label value MCDAU98 H280531X;
label value MCDAU98X H280532X;
label value MCDDE98 H280533X;
label value MCDDE98X H280534X;
label value MCDEV98 H280535X;
label value MCDFE98 H280536X;
label value MCDFE98X H280537X;
label value MCDJA98 H280538X;
label value MCDJA98X H280539X;
label value MCDJL98 H280540X;
label value MCDJL98X H280541X;
label value MCDJU98 H280542X;
label value MCDJU98X H280543X;
label value MCDMA98 H280544X;
label value MCDMA98X H280545X;
label value MCDMY98 H280546X;
label value MCDMY98X H280547X;
label value MCDNO98 H280548X;
label value MCDNO98X H280549X;
label value MCDOC98 H280550X;
label value MCDOC98X H280551X;
label value MCDSE98 H280552X;
label value MCDSE98X H280553X;
label value MCRAP98 H280554X;
label value MCRAP98X H280555X;
label value MCRAU98 H280556X;
label value MCRAU98X H280557X;
label value MCRDE98 H280558X;
label value MCRDE98X H280559X;
label value MCREV98 H280560X;
label value MCRFE98 H280561X;
label value MCRFE98X H280562X;
label value MCRJA98 H280563X;
label value MCRJA98X H280564X;
label value MCRJL98 H280565X;
label value MCRJL98X H280566X;
label value MCRJU98 H280567X;
label value MCRJU98X H280568X;
label value MCRMA98 H280569X;
label value MCRMA98X H280570X;
label value MCRMY98 H280571X;
label value MCRMY98X H280572X;
label value MCRNO98 H280573X;
label value MCRNO98X H280574X;
label value MCROC98 H280575X;
label value MCROC98X H280576X;
label value MCRSE98 H280577X;
label value MCRSE98X H280578X;
label value MDTRT98 H280579X;
label value MEDITA98 H280580X;
label value MEXAMT98 H280581X;
label value MILDIF31 H280582X;
label value MILDIF53 H280583X;
label value MMRSHT42 H280584X;
label value MNHLTH31 H280585X;
label value MNHLTH42 H280586X;
label value MNHLTH53 H280587X;
label value MNPROX31 H280588X;
label value MNPROX42 H280589X;
label value MNPROX53 H280590X;
label value MOMPRO42 H280591X;
label value MORE31 H280592X;
label value MORE42 H280593X;
label value MORE53 H280594X;
label value MORJOB31 H280595X;
label value MORJOB42 H280596X;
label value MORJOB53 H280597X;
label value MSA53 H280598X;
label value MSA98 H280599X;
label value NERVAF42 H280600X;
label value NTHLTH42 H280601X;
label value NTMDED98 H280602X;
label value NUMDPT42 H280603X;
label value NUMEMP31 H280604X;
label value NUMEMP42 H280605X;
label value NUMEMP53 H280606X;
label value NUMPOL42 H280607X;
label value NURTRT98 H280608X;
label value NUTRIT98 H280609X;
label value NWK31 H280610X;
label value NWK42 H280611X;
label value NWK53 H280612X;
label value OBACHM98 H280613X;
label value OBAEXP98 H280614X;
label value OBAMCD98 H280615X;
label value OBAMCR98 H280616X;
label value OBAOFD98 H280617X;
label value OBAOPR98 H280618X;
label value OBAOPU98 H280619X;
label value OBAOSR98 H280620X;
label value OBAPRV98 H280621X;
label value OBASLF98 H280622X;
label value OBASST98 H280623X;
label value OBASTL98 H280624X;
label value OBATCH98 H280625X;
label value OBAVA98 H280626X;
label value OBAWCP98 H280627X;
label value OBCCHM98 H280628X;
label value OBCEXP98 H280629X;
label value OBCHIR98 H280630X;
label value OBCMCD98 H280631X;
label value OBCMCR98 H280632X;
label value OBCOFD98 H280633X;
label value OBCOPR98 H280634X;
label value OBCOPU98 H280635X;
label value OBCOSR98 H280636X;
label value OBCPRV98 H280637X;
label value OBCSLF98 H280638X;
label value OBCSTL98 H280639X;
label value OBCTCH98 H280640X;
label value OBCVA98 H280641X;
label value OBCWCP98 H280642X;
label value OBDCHM98 H280643X;
label value OBDEXP98 H280644X;
label value OBDMCD98 H280645X;
label value OBDMCR98 H280646X;
label value OBDOFD98 H280647X;
label value OBDOPR98 H280648X;
label value OBDOPU98 H280649X;
label value OBDOSR98 H280650X;
label value OBDPRV98 H280651X;
label value OBDRV98 H280652X;
label value OBDSLF98 H280653X;
label value OBDSTL98 H280654X;
label value OBDTCH98 H280655X;
label value OBDVA98 H280656X;
label value OBDWCP98 H280657X;
label value OBECHM98 H280658X;
label value OBEEXP98 H280659X;
label value OBEMCD98 H280660X;
label value OBEMCR98 H280661X;
label value OBEOFD98 H280662X;
label value OBEOPR98 H280663X;
label value OBEOPU98 H280664X;
label value OBEOSR98 H280665X;
label value OBEPRV98 H280666X;
label value OBESLF98 H280667X;
label value OBESTL98 H280668X;
label value OBETCH98 H280669X;
label value OBEVA98 H280670X;
label value OBEWCP98 H280671X;
label value OBNCHM98 H280672X;
label value OBNEXP98 H280673X;
label value OBNMCD98 H280674X;
label value OBNMCR98 H280675X;
label value OBNOFD98 H280676X;
label value OBNOPR98 H280677X;
label value OBNOPU98 H280678X;
label value OBNOSR98 H280679X;
label value OBNPRV98 H280680X;
label value OBNSLF98 H280681X;
label value OBNSTL98 H280682X;
label value OBNTCH98 H280683X;
label value OBNURS98 H280684X;
label value OBNVA98 H280685X;
label value OBNWCP98 H280686X;
label value OBOCHM98 H280687X;
label value OBOEXP98 H280688X;
label value OBOMCD98 H280689X;
label value OBOMCR98 H280690X;
label value OBOOFD98 H280691X;
label value OBOOPR98 H280692X;
label value OBOOPU98 H280693X;
label value OBOOSR98 H280694X;
label value OBOPRV98 H280695X;
label value OBOPTO98 H280696X;
label value OBOSLF98 H280697X;
label value OBOSTL98 H280698X;
label value OBOTCH98 H280699X;
label value OBOTHV98 H280700X;
label value OBOVA98 H280701X;
label value OBOWCP98 H280702X;
label value OBTCHM98 H280703X;
label value OBTEXP98 H280704X;
label value OBTHER98 H280705X;
label value OBTMCD98 H280706X;
label value OBTMCR98 H280707X;
label value OBTOFD98 H280708X;
label value OBTOPR98 H280709X;
label value OBTOPU98 H280710X;
label value OBTOSR98 H280711X;
label value OBTOTV98 H280712X;
label value OBTPRV98 H280713X;
label value OBTSLF98 H280714X;
label value OBTSTL98 H280715X;
label value OBTTCH98 H280716X;
label value OBTVA98 H280717X;
label value OBTWCP98 H280718X;
label value OBVCHM98 H280719X;
label value OBVEXP98 H280720X;
label value OBVMCD98 H280721X;
label value OBVMCR98 H280722X;
label value OBVOFD98 H280723X;
label value OBVOPR98 H280724X;
label value OBVOPU98 H280725X;
label value OBVOSR98 H280726X;
label value OBVPRV98 H280727X;
label value OBVSLF98 H280728X;
label value OBVSTL98 H280729X;
label value OBVTCH98 H280730X;
label value OBVVA98 H280731X;
label value OBVWCP98 H280732X;
label value OCUPTH42 H280733X;
label value OFFER31X H280734X;
label value OFFER42X H280735X;
label value OFFER53X H280736X;
label value OPAAP98 H280737X;
label value OPAAU98 H280738X;
label value OPADE98 H280739X;
label value OPAEV98 H280740X;
label value OPAFE98 H280741X;
label value OPAJA98 H280742X;
label value OPAJL98 H280743X;
label value OPAJU98 H280744X;
label value OPAMA98 H280745X;
label value OPAMY98 H280746X;
label value OPANO98 H280747X;
label value OPAOC98 H280748X;
label value OPASE98 H280749X;
label value OPBAP98 H280750X;
label value OPBAU98 H280751X;
label value OPBDE98 H280752X;
label value OPBEV98 H280753X;
label value OPBFE98 H280754X;
label value OPBJA98 H280755X;
label value OPBJL98 H280756X;
label value OPBJU98 H280757X;
label value OPBMA98 H280758X;
label value OPBMY98 H280759X;
label value OPBNO98 H280760X;
label value OPBOC98 H280761X;
label value OPBSE98 H280762X;
label value OPDCHM98 H280763X;
label value OPDEXP98 H280764X;
label value OPDMCD98 H280765X;
label value OPDMCR98 H280766X;
label value OPDOFD98 H280767X;
label value OPDOPR98 H280768X;
label value OPDOPU98 H280769X;
label value OPDOSR98 H280770X;
label value OPDPRV98 H280771X;
label value OPDRV98 H280772X;
label value OPDSLF98 H280773X;
label value OPDSTL98 H280774X;
label value OPDTCH98 H280775X;
label value OPDVA98 H280776X;
label value OPDWCP98 H280777X;
label value OPFCHM98 H280778X;
label value OPFEXP98 H280779X;
label value OPFMCD98 H280780X;
label value OPFMCR98 H280781X;
label value OPFOFD98 H280782X;
label value OPFOPR98 H280783X;
label value OPFOPU98 H280784X;
label value OPFOSR98 H280785X;
label value OPFPRV98 H280786X;
label value OPFSLF98 H280787X;
label value OPFSTL98 H280788X;
label value OPFTCH98 H280789X;
label value OPFVA98 H280790X;
label value OPFWCP98 H280791X;
label value OPOCHM98 H280792X;
label value OPOEXP98 H280793X;
label value OPOMCD98 H280794X;
label value OPOMCR98 H280795X;
label value OPOOFD98 H280796X;
label value OPOOPR98 H280797X;
label value OPOOPU98 H280798X;
label value OPOOSR98 H280799X;
label value OPOPRV98 H280800X;
label value OPOSLF98 H280801X;
label value OPOSTL98 H280802X;
label value OPOTCH98 H280803X;
label value OPOTHV98 H280804X;
label value OPOVA98 H280805X;
label value OPOWCP98 H280806X;
label value OPPCHM98 H280807X;
label value OPPEXP98 H280808X;
label value OPPMCD98 H280809X;
label value OPPMCR98 H280810X;
label value OPPOFD98 H280811X;
label value OPPOPR98 H280812X;
label value OPPOPU98 H280813X;
label value OPPOSR98 H280814X;
label value OPPPRV98 H280815X;
label value OPPSLF98 H280816X;
label value OPPSTL98 H280817X;
label value OPPTCH98 H280818X;
label value OPPVA98 H280819X;
label value OPPWCP98 H280820X;
label value OPSCHM98 H280821X;
label value OPSEXP98 H280822X;
label value OPSMCD98 H280823X;
label value OPSMCR98 H280824X;
label value OPSOFD98 H280825X;
label value OPSOPR98 H280826X;
label value OPSOPU98 H280827X;
label value OPSOSR98 H280828X;
label value OPSPRV98 H280829X;
label value OPSSLF98 H280830X;
label value OPSSTL98 H280831X;
label value OPSTCH98 H280832X;
label value OPSVA98 H280833X;
label value OPSWCP98 H280834X;
label value OPTOTV98 H280835X;
label value OPVCHM98 H280836X;
label value OPVEXP98 H280837X;
label value OPVMCD98 H280838X;
label value OPVMCR98 H280839X;
label value OPVOFD98 H280840X;
label value OPVOPR98 H280841X;
label value OPVOPU98 H280842X;
label value OPVOSR98 H280843X;
label value OPVPRV98 H280844X;
label value OPVSLF98 H280845X;
label value OPVSTL98 H280846X;
label value OPVTCH98 H280847X;
label value OPVVA98 H280848X;
label value OPVWCP98 H280849X;
label value OTHALT98 H280850X;
label value OTHCHM98 H280851X;
label value OTHEXP98 H280852X;
label value OTHIMP98 H280853X;
label value OTHMCD98 H280854X;
label value OTHMCR98 H280855X;
label value OTHOFD98 H280856X;
label value OTHOPR98 H280857X;
label value OTHOPU98 H280858X;
label value OTHOSR98 H280859X;
label value OTHPRV98 H280860X;
label value OTHSLF98 H280861X;
label value OTHSTL98 H280862X;
label value OTHSVC42 H280863X;
label value OTHTCH98 H280864X;
label value OTHVA98 H280865X;
label value OTHWCP98 H280866X;
label value PANEL98 H280867X;
label value PAPSMR98 H280868X;
label value PAYDR31 H280869X;
label value PAYDR42 H280870X;
label value PAYDR53 H280871X;
label value PAYVAC31 H280872X;
label value PAYVAC42 H280873X;
label value PAYVAC53 H280874X;
label value PDKAP98 H280875X;
label value PDKAU98 H280876X;
label value PDKDE98 H280877X;
label value PDKFE98 H280878X;
label value PDKJA98 H280879X;
label value PDKJL98 H280880X;
label value PDKJU98 H280881X;
label value PDKMA98 H280882X;
label value PDKMY98 H280883X;
label value PDKNO98 H280884X;
label value PDKOC98 H280885X;
label value PDKSE98 H280886X;
label value PEGAP98 H280887X;
label value PEGAU98 H280888X;
label value PEGDE98 H280889X;
label value PEGFE98 H280890X;
label value PEGJA98 H280891X;
label value PEGJL98 H280892X;
label value PEGJU98 H280893X;
label value PEGMA98 H280894X;
label value PEGMY98 H280895X;
label value PEGNO98 H280896X;
label value PEGOC98 H280897X;
label value PEGSE98 H280898X;
label value PENIMP98 H280899X;
label value PERINS98 H280900X;
label value PHYSCL98 H280901X;
label value PHYTHR42 H280902X;
label value PLYLIM42 H280903X;
label value PNGAP98 H280904X;
label value PNGAU98 H280905X;
label value PNGDE98 H280906X;
label value PNGFE98 H280907X;
label value PNGJA98 H280908X;
label value PNGJL98 H280909X;
label value PNGJU98 H280910X;
label value PNGMA98 H280911X;
label value PNGMY98 H280912X;
label value PNGNO98 H280913X;
label value PNGOC98 H280914X;
label value PNGSE98 H280915X;
label value POGAP98 H280916X;
label value POGAU98 H280917X;
label value POGDE98 H280918X;
label value POGFE98 H280919X;
label value POGJA98 H280920X;
label value POGJL98 H280921X;
label value POGJU98 H280922X;
label value POGMA98 H280923X;
label value POGMY98 H280924X;
label value POGNO98 H280925X;
label value POGOC98 H280926X;
label value POGSE98 H280927X;
label value POLSHT42 H280928X;
label value POUAP98 H280929X;
label value POUAU98 H280930X;
label value POUDE98 H280931X;
label value POUFE98 H280932X;
label value POUJA98 H280933X;
label value POUJL98 H280934X;
label value POUJU98 H280935X;
label value POUMA98 H280936X;
label value POUMY98 H280937X;
label value POUNO98 H280938X;
label value POUOC98 H280939X;
label value POUSE98 H280940X;
label value POVCAT98 H280941X;
label value PRALTE98 H280942X;
label value PRALTX98 H280943X;
label value PRIAP98 H280944X;
label value PRIAU98 H280945X;
label value PRIDE98 H280946X;
label value PRIFE98 H280947X;
label value PRIJA98 H280948X;
label value PRIJL98 H280949X;
label value PRIJU98 H280950X;
label value PRIMA98 H280951X;
label value PRIMY98 H280952X;
label value PRINO98 H280953X;
label value PRIOC98 H280954X;
label value PRISE98 H280955X;
label value PROSEX98 H280956X;
label value PROXY31 H280957X;
label value PROXY42 H280958X;
label value PROXY53 H280959X;
label value PROXY98 H280960X;
label value PRSAP98 H280961X;
label value PRSAU98 H280962X;
label value PRSDE98 H280963X;
label value PRSFE98 H280964X;
label value PRSJA98 H280965X;
label value PRSJL98 H280966X;
label value PRSJU98 H280967X;
label value PRSMA98 H280968X;
label value PRSMY98 H280969X;
label value PRSNO98 H280970X;
label value PRSOC98 H280971X;
label value PRSSE98 H280972X;
label value PRVEV98 H280973X;
label value PSTATS31 H280974X;
label value PSTATS42 H280975X;
label value PSTATS53 H280976X;
label value PSYCNS42 H280977X;
label value PUBAP98X H280978X;
label value PUBAU98X H280979X;
label value PUBDE98X H280980X;
label value PUBFE98X H280981X;
label value PUBIMP98 H280982X;
label value PUBJA98X H280983X;
label value PUBJL98X H280984X;
label value PUBJU98X H280985X;
label value PUBMA98X H280986X;
label value PUBMY98X H280987X;
label value PUBNO98X H280988X;
label value PUBOC98X H280989X;
label value PUBSE98X H280990X;
label value R2FLAG H280991X;
label value RACETHNX H280992X;
label value RACEX H280993X;
label value RCHDIF31 H280994X;
label value RCHDIF53 H280995X;
label value READIN42 H280996X;
label value READNW42 H280997X;
label value RECPEP42 H280998X;
label value RECTHR42 H280999X;
label value REFIMP98 H281000X;
label value REFRMD98 H281001X;
label value REGION31 H281002X;
label value REGION42 H281003X;
label value REGION53 H281004X;
label value REGION98 H281005X;
label value RESP31 H281006X;
label value RESP42 H281007X;
label value RESP53 H281008X;
label value RESP98 H281009X;
label value RETPLN31 H281010X;
label value RETPLN42 H281011X;
label value RETPLN53 H281012X;
label value RFREL31X H281013X;
label value RFREL42X H281014X;
label value RFREL53X H281015X;
label value RFREL98X H281016X;
label value RNDFLG31 H281017X;
label value RTHLTH31 H281018X;
label value RTHLTH42 H281019X;
label value RTHLTH53 H281020X;
label value RTPROX31 H281021X;
label value RTPROX42 H281022X;
label value RTPROX53 H281023X;
label value RUCLAS31 H281024X;
label value RUCLAS42 H281025X;
label value RUCLAS53 H281026X;
label value RUCLAS98 H281027X;
label value RUSIZE31 H281028X;
label value RUSIZE42 H281029X;
label value RUSIZE53 H281030X;
label value RUSIZE98 H281031X;
label value RXCHM98 H281032X;
label value RXEXP98 H281033X;
label value RXMCD98 H281034X;
label value RXMCR98 H281035X;
label value RXOFD98 H281036X;
label value RXOPR98 H281037X;
label value RXOPU98 H281038X;
label value RXOSR98 H281039X;
label value RXPRV98 H281040X;
label value RXSLF98 H281041X;
label value RXSTL98 H281042X;
label value RXTOT98 H281043X;
label value RXVA98 H281044X;
label value RXWCP98 H281045X;
label value SALIMP98 H281046X;
label value SCHLBH42 H281047X;
label value SCHLIM31 H281048X;
label value SCHLIM53 H281049X;
label value SCHPRO42 H281050X;
label value SEEDIF42 H281051X;
label value SELFCM31 H281052X;
label value SELFCM42 H281053X;
label value SELFCM53 H281054X;
label value SEX H281055X;
label value SHFTWK31 H281056X;
label value SHFTWK42 H281057X;
label value SHFTWK53 H281058X;
label value SIBPRO42 H281059X;
label value SICPAY31 H281060X;
label value SICPAY42 H281061X;
label value SICPAY53 H281062X;
label value SOCLIM31 H281063X;
label value SOCLIM53 H281064X;
label value SPCHTH42 H281065X;
label value SPCPRO42 H281066X;
label value SPCSCH42 H281067X;
label value SPECED42 H281068X;
label value SPIRTL98 H281069X;
label value SPOUID31 H281070X;
label value SPOUID42 H281071X;
label value SPOUID53 H281072X;
label value SPOUID98 H281073X;
label value SPOUIN31 H281074X;
label value SPOUIN42 H281075X;
label value SPOUIN53 H281076X;
label value SPOUIN98 H281077X;
label value SPRPRO42 H281078X;
label value SSCIMP98 H281079X;
label value SSECTX98 H281080X;
label value SSIDIS98 H281081X;
label value SSIIMP98 H281082X;
label value STAAP98 H281083X;
label value STAAU98 H281084X;
label value STADE98 H281085X;
label value STAFE98 H281086X;
label value STAJA98 H281087X;
label value STAJL98 H281088X;
label value STAJU98 H281089X;
label value STAMA98 H281090X;
label value STAMY98 H281091X;
label value STANO98 H281092X;
label value STAOC98 H281093X;
label value STASE98 H281094X;
label value STJBDD31 H281095X;
label value STJBDD42 H281096X;
label value STJBDD53 H281097X;
label value STJBMM31 H281098X;
label value STJBMM42 H281099X;
label value STJBMM53 H281100X;
label value STJBYY31 H281101X;
label value STJBYY42 H281102X;
label value STJBYY53 H281103X;
label value STNDIF31 H281104X;
label value STNDIF53 H281105X;
label value STPDIF31 H281106X;
label value STPDIF53 H281107X;
label value TAXFRM98 H281108X;
label value TOTCHM98 H281109X;
label value TOTDED98 H281110X;
label value TOTEXP98 H281111X;
label value TOTMCD98 H281112X;
label value TOTMCR98 H281113X;
label value TOTOFD98 H281114X;
label value TOTOPR98 H281115X;
label value TOTOPU98 H281116X;
label value TOTOSR98 H281117X;
label value TOTPRV98 H281118X;
label value TOTSLF98 H281119X;
label value TOTSTL98 H281120X;
label value TOTTCH98 H281121X;
label value TOTVA98 H281122X;
label value TOTWCP98 H281123X;
label value TRADIT98 H281124X;
label value TRBLE42 H281125X;
label value TRTIMP98 H281126X;
label value TUTOR42 H281127X;
label value UNABLE31 H281128X;
label value UNABLE53 H281129X;
label value UNEIMP98 H281130X;
label value UNEMTX98 H281131X;
label value UNHAP42 H281132X;
label value UNINS98 H281133X;
label value UNION31 H281134X;
label value UNION42 H281135X;
label value UNION53 H281136X;
label value VETIMP98 H281137X;
label value VETKOR H281138X;
label value VETOTH H281139X;
label value VETPVIET H281140X;
label value VETVIET H281141X;
label value VETWW H281142X;
label value VISCHM98 H281143X;
label value VISEXP98 H281144X;
label value VISION42 H281145X;
label value VISMCD98 H281146X;
label value VISMCR98 H281147X;
label value VISOFD98 H281148X;
label value VISOPR98 H281149X;
label value VISOPU98 H281150X;
label value VISOSR98 H281151X;
label value VISPRV98 H281152X;
label value VISSLF98 H281153X;
label value VISSTL98 H281154X;
label value VISTCH98 H281155X;
label value VISVA98 H281156X;
label value VISWCP98 H281157X;
label value VOCSVC42 H281158X;
label value WAGEP98X H281159X;
label value WAGIMP98 H281160X;
label value WCPIMP98 H281161X;
label value WGTLB42 H281162X;
label value WGTOZ42 H281163X;
label value WHOCAR98 H281164X;
label value WHRCAR98 H281165X;
label value WILFIL98 H281166X;
label value WLKDIF31 H281167X;
label value WLKDIF53 H281168X;
label value WLKLIM31 H281169X;
label value WLKLIM53 H281170X;
label value WRDENT98 H281171X;
label value WRGLAS42 H281172X;
label value WRKLIM31 H281173X;
label value WRKLIM53 H281174X;
label value YCHJ3142 H281175X;
label value YCHJ4253 H281176X;
label value ZIDCHM98 H281177X;
label value ZIDEXP98 H281178X;
label value ZIDMCD98 H281179X;
label value ZIDMCR98 H281180X;
label value ZIDOFD98 H281181X;
label value ZIDOPR98 H281182X;
label value ZIDOPU98 H281183X;
label value ZIDOSR98 H281184X;
label value ZIDPRV98 H281185X;
label value ZIDSLF98 H281186X;
label value ZIDSTL98 H281187X;
label value ZIDTCH98 H281188X;
label value ZIDVA98 H281189X;
label value ZIDWCP98 H281190X;
label value ZIFCHM98 H281191X;
label value ZIFEXP98 H281192X;
label value ZIFMCD98 H281193X;
label value ZIFMCR98 H281194X;
label value ZIFOFD98 H281195X;
label value ZIFOPR98 H281196X;
label value ZIFOPU98 H281197X;
label value ZIFOSR98 H281198X;
label value ZIFPRV98 H281199X;
label value ZIFSLF98 H281200X;
label value ZIFSTL98 H281201X;
label value ZIFTCH98 H281202X;
label value ZIFVA98 H281203X;
label value ZIFWCP98 H281204X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr



/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H28.LOG and a data file named H28.DTA.  If these files (H28.DTA and H28.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

